/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum StringType {
    NARROW("", 130),
    WIDE("L", 131),
    UTF16("u", 5000),
    UTF32("U", 5001);

    private char[] prefix;
    private int tokenVal;

    private StringType(String prefix, int tokenVal) {
        this.prefix = prefix.toCharArray();
        this.tokenVal = tokenVal;
    }

    public char[] getPrefix() {
        return this.prefix;
    }

    public int getTokenValue() {
        return this.tokenVal;
    }

    public static StringType max(StringType st1, StringType st2) {
        return StringType.values()[Math.max(st1.ordinal(), st2.ordinal())];
    }

    public static StringType fromToken(int tokenVal) {
        switch (tokenVal) {
            case 130: {
                return NARROW;
            }
            case 131: {
                return WIDE;
            }
            case 5000: {
                return UTF16;
            }
            case 5001: {
                return UTF32;
            }
        }
        throw new IllegalArgumentException(String.valueOf(tokenVal) + " is not a string token");
    }
}

