/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.tizen.dynamicanalyzer.common.AccessLog;
import org.tizen.dynamicanalyzer.common.ActionLog;
import org.tizen.dynamicanalyzer.common.AnalyticConfig;
import org.tizen.dynamicanalyzer.common.DeleteUser;
import org.tizen.dynamicanalyzer.common.UsageLog;
import org.tizen.dynamicanalyzer.common.path.PathManager;

public class RemoteLogger {
    private static final Logger logger = Logger.getLogger("RemoteLogger");
    private static final String DEFAULT_VERSION = "Default";
    private static final String DIR_IDE = "ide";
    private static final String ANALYTICS_CONFIG_FILE = "analytics.conf";
    private static final String LOGGING_URL = "https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1";
    private static final Map<String, String> mapUrl = RemoteLogger.getMapValues();

    private static AnalyticConfig parseConfig(Path filePath) {
        File f = new File(filePath.toString());
        AnalyticConfig config = new AnalyticConfig("", false);
        if (f.exists()) {
            Gson gson = new Gson();
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedReader reader = Files.newBufferedReader(filePath);){
                    AnalyticConfig data = (AnalyticConfig)gson.fromJson((Reader)reader, AnalyticConfig.class);
                    if (data != null && data.id != null && data.logging != null) {
                        config.id = data.id;
                        config.logging = data.logging;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return config;
            }
        }
        return config;
    }

    private static final Map<String, String> getMapValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("usage", "postusage");
        map.put("access", "postaccess");
        map.put("deleteUser", "deleteuser");
        return map;
    }

    public static Boolean isLoggingEnabled() {
        return RemoteLogger.getAnalyticsConf().logging;
    }

    public static void writeLoggingInfoToFile(Boolean log) {
        RemoteLogger.writeAnalyticsConf(RemoteLogger.getAnalyticsConf().id, log);
    }

    public static String getIdeUserDataPath() {
        return String.valueOf(PathManager.TIZEN_SDK_DATA_PATH) + File.separator + DIR_IDE;
    }

    private static String getAnalyticsConfig() {
        String dataPath = RemoteLogger.getIdeUserDataPath();
        File f = new File(dataPath);
        if (!f.exists()) {
            f.mkdirs();
        }
        Path filePath = Paths.get(dataPath, ANALYTICS_CONFIG_FILE);
        return filePath.toString();
    }

    private static AnalyticConfig writeAnalyticsConf(String uuid, Boolean log) {
        Path filePath = Paths.get(RemoteLogger.getAnalyticsConfig(), new String[0]);
        File f = new File(filePath.toString());
        f.delete();
        AnalyticConfig config = new AnalyticConfig(uuid, log);
        Gson gson = new Gson();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileWriter writer = new FileWriter(filePath.toString());){
                gson.toJson((Object)config, (Appendable)writer);
                ((Writer)writer).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonIOException | IOException e) {
            e.printStackTrace();
            return config;
        }
        return config;
    }

    private static AnalyticConfig getAnalyticsConf() {
        Path filePath = Paths.get(RemoteLogger.getAnalyticsConfig(), new String[0]);
        File f = new File(filePath.toString());
        AnalyticConfig config = RemoteLogger.parseConfig(filePath);
        if (config.id.isEmpty()) {
            f.delete();
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            return RemoteLogger.writeAnalyticsConf(id, true);
        }
        return config;
    }

    private static String getVersion() throws IOException {
        Path filePath = Paths.get(PathManager.TIZEN_SDK_INSTALL_PATH, "sdk.version");
        byte[] encoded = Files.readAllBytes(Paths.get(filePath.toString(), new String[0]));
        String content = new String(encoded, StandardCharsets.UTF_8);
        String[] data = content.split("=");
        if (data.length < 2) {
            return DEFAULT_VERSION;
        }
        data[1] = data[1].replaceAll("[\\n\\t ]", "");
        return data[1];
    }

    private static void sendLogs(ActionLog log, String type) throws IOException {
        URL url = new URL("https://1lxb5yo2lb.execute-api.ap-northeast-2.amazonaws.com/v1/" + mapUrl.get(type));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        Gson gson = new Gson();
        String json = gson.toJson((Object)log);
        OutputStream os = conn.getOutputStream();
        os.write(json.getBytes("UTF-8"));
        os.close();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        String result = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        logger.info(result);
    }

    private static void createLog(String product, long usage, String type) {
        String version;
        AnalyticConfig conf = RemoteLogger.getAnalyticsConf();
        String uuid = conf.id;
        if (uuid.isEmpty()) {
            logger.info("Failed to generate UUID");
            return;
        }
        if (!conf.logging.booleanValue()) {
            logger.info("Logging is disabled by user");
            return;
        }
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timestamp = fmt.format(now);
        try {
            version = RemoteLogger.getVersion();
        }
        catch (IOException iOException) {
            logger.info("Failed to get version");
            version = DEFAULT_VERSION;
        }
        ActionLog log = type.equals("access") ? new AccessLog(uuid, type, product, version, timestamp) : (type.equals("usage") ? new UsageLog(uuid, type, product, version, timestamp, usage) : new DeleteUser(uuid));
        try {
            RemoteLogger.sendLogs(log, type);
        }
        catch (IOException iOException) {
            logger.info("Post Request failed while trying to access server URL");
        }
    }

    public static void logAccess(String product) {
        RemoteLogger.createLog(product, 0L, "access");
    }

    public static void deleteAnalytics() {
        RemoteLogger.createLog(null, 0L, "deleteUser");
    }

    public static void logUsage(String product, long usage) {
        RemoteLogger.createLog(product, usage, "usage");
    }
}

