/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmBackgroundProperties
extends HierarchyUIObjectProperties {
    private int[] color = new int[3];
    private String option;

    public ElmBackgroundProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.color[0] = parser.getInt();
        this.color[1] = parser.getInt();
        this.color[2] = parser.getInt();
        this.option = this.getOptionMessage(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("color", "[" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + "]"));
        properties.add(new PropertyValue("option", this.option));
        return properties;
    }

    private String getOptionMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_BG_OPTION_CENTER";
            }
            case 1: {
                return "ELM_BG_OPTION_SCALE";
            }
            case 2: {
                return "ELM_BG_OPTION_STRETCH";
            }
            case 3: {
                return "ELM_BG_OPTION_TILE";
            }
            case 4: {
                return "ELM_BG_OPTION_LAST";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

