/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.layout;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.figure.HierarchyTreeFigure;

public class HierarchyLayoutFigure
extends Figure {
    private static final int MARGIN_X = 14;
    private static final int MARGIN_Y = 14;
    private static final int MAX_WIDTH = 10000;
    private static final int MAX_HEIGHT = 10000;
    private IFigure sourceFigure;
    private HierarchyUIObject selectedUIObj;

    public void setSource(IFigure sourceFigure) {
        this.sourceFigure = sourceFigure;
    }

    public void setSelectedUIObj(HierarchyUIObject selectedUIObj) {
        this.selectedUIObj = selectedUIObj;
    }

    public void paintFigure(Graphics graphics) {
        if (this.selectedUIObj == null) {
            return;
        }
        List children = this.sourceFigure.getChildren();
        if (children.isEmpty()) {
            return;
        }
        HierarchyTreeFigure rootFigure = (HierarchyTreeFigure)((Object)children.get(0));
        org.eclipse.draw2d.geometry.Rectangle unionArea = new org.eclipse.draw2d.geometry.Rectangle();
        this.getUIObjUnionSize(rootFigure, unionArea);
        Dimension realWindowSize = unionArea.getSize();
        Dimension windowSize = this.getAdjustWindowSize(this.getBounds().getSize(), realWindowSize);
        int windowX = this.getClientArea().x + (this.getClientArea().width - windowSize.width) / 2;
        int windowY = this.getClientArea().y + (this.getClientArea().height - windowSize.height) / 2;
        graphics.setForegroundColor(ColorResources.LAYOUTVIEW_NORMAL_STROKE);
        this.paintContents(rootFigure, graphics, realWindowSize, windowSize, windowX, windowY);
        this.paintHighlight(graphics, realWindowSize, windowSize, windowX, windowY);
    }

    private void getUIObjUnionSize(HierarchyTreeFigure treeFigure, org.eclipse.draw2d.geometry.Rectangle unionArea) {
        int[] geom = this.selectedUIObj.getGeometry();
        int x = geom[0];
        int y = geom[1];
        int width = geom[2];
        int height = geom[3];
        if (width < 10000 && height < 10000) {
            unionArea.union(x, y, width, height);
        }
        List children = treeFigure.getBranch().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.getUIObjUnionSize((HierarchyTreeFigure)((Object)children.get(i)), unionArea);
            ++i;
        }
    }

    private void paintContents(HierarchyTreeFigure treeFigure, Graphics graphics, Dimension realWindowSize, Dimension windowSize, int windowX, int windowY) {
        HierarchyUIObject uiObj = treeFigure.getNode().getUIObject();
        int[] geom = this.selectedUIObj.getGeometry();
        double uiObjX = geom[0];
        double uiObjY = geom[1];
        int adjustedX = windowX + (int)Math.round(uiObjX * (double)windowSize.width / (double)realWindowSize.width);
        int adjustedY = windowY + (int)Math.round(uiObjY * (double)windowSize.height / (double)realWindowSize.height);
        int adjustedWidth = windowSize.width * uiObj.getGeometry()[2] / realWindowSize.width;
        int adjustedHeight = windowSize.height * uiObj.getGeometry()[3] / realWindowSize.height;
        graphics.drawRectangle(adjustedX, adjustedY, adjustedWidth, adjustedHeight);
        List children = treeFigure.getBranch().getChildren();
        int i = 0;
        while (i < children.size()) {
            this.paintContents((HierarchyTreeFigure)((Object)children.get(i)), graphics, realWindowSize, windowSize, windowX, windowY);
            ++i;
        }
    }

    private void paintHighlight(Graphics gc, Dimension realWindowSize, Dimension windowSize, int windowX, int windowY) {
        gc.setForegroundColor(ColorResources.LAYOUTVIEW_SELECTED_STROKE);
        int[] geom = this.selectedUIObj.getGeometry();
        int uiObjX = geom[0];
        int uiObjY = geom[1];
        int uiObjWidth = geom[2];
        int uiObjHeight = geom[3];
        int adjustedX = windowX + (int)Math.round((double)uiObjX * (double)windowSize.width / (double)realWindowSize.width);
        int adjustedY = windowY + (int)Math.round((double)uiObjY * (double)windowSize.height / (double)realWindowSize.height);
        int adjustedWidth = windowSize.width * uiObjWidth / realWindowSize.width;
        int adjustedHeight = windowSize.height * uiObjHeight / realWindowSize.height;
        gc.setLineWidth(2);
        gc.drawRectangle(adjustedX, adjustedY, adjustedWidth, adjustedHeight);
        String imagePath = this.selectedUIObj.getImageFilePath();
        if (this.selectedUIObj.getStatus() == HierarchyUIObject.STATUS.OK && imagePath != null) {
            Image image = new Image((Device)Display.getDefault(), imagePath);
            Rectangle bounds = image.getBounds();
            gc.drawImage(image, 0, 0, bounds.width, bounds.height, adjustedX, adjustedY, adjustedWidth, adjustedHeight);
        }
    }

    private Dimension getAdjustWindowSize(Dimension viewSize, Dimension sourceSize) {
        Dimension adjustedSize = new Dimension(viewSize.width - 28, viewSize.height - 28);
        adjustedSize.width = Math.min(adjustedSize.width, (int)((double)((float)(adjustedSize.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
        adjustedSize.height = Math.min(adjustedSize.height, (int)((double)((float)(adjustedSize.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        return adjustedSize;
    }
}

