/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command.message;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.sdb.command.message.CommandErrorException;
import org.tizen.common.sdb.command.message.CommandErrorType;
import org.tizen.common.sdb.command.message.ErrorMessageType;
import org.tizen.common.sdb.command.message.PkgcmdErrorMessages;
import org.tizen.sdblib.util.StringUtil;

public class PkgcmdErrorType
implements CommandErrorType {
    private static final String ERROR_MESSAGE_TEMPLATE = "error message: ";
    private static final int DEFAULT_ERROR_CODE = 9999;
    private ErrorMessageType errorType;
    private String command;
    private String commandOutput;
    private String backendErrorMessage = "";
    private String errorMessage = "";
    private int errorCode = 9999;
    private final Pattern resultPattern = Pattern.compile("processing result : (.*) \\[(.*)\\] failed");

    @Override
    public boolean findErrorType(int exitCode, String command) {
        if (this.errorCode == 9999) {
            this.errorCode = exitCode;
        }
        this.errorType = ErrorMessageType.getErrorType(this.errorCode);
        if (this.errorType == null) {
            return false;
        }
        this.command = command;
        return true;
    }

    @Override
    public String getMessage() {
        if (this.errorType == null) {
            if (!StringUtil.isEmpty((CharSequence)this.errorMessage)) {
                return String.format("%s [%d]", this.errorMessage, this.errorCode);
            }
            return null;
        }
        String errorMsg = this.errorMessage;
        if (StringUtil.isEmpty((CharSequence)this.errorMessage) && !StringUtil.isEmpty((CharSequence)this.backendErrorMessage)) {
            errorMsg = this.backendErrorMessage;
        }
        return String.format(PkgcmdErrorMessages.MESSAGE_FORMAT, this.errorType.name(), errorMsg, this.command, this.errorType.getManagement());
    }

    private void parseErrorResultMessage() {
        Matcher matcher = this.resultPattern.matcher(this.commandOutput);
        if (matcher.find()) {
            String message = matcher.group(1);
            String code = matcher.group(2);
            this.errorMessage = message != null ? message : "";
            this.errorCode = code != null ? Integer.parseInt(code) : 9999;
        }
    }

    @Override
    public int getExitCode() {
        if (this.errorType == null) {
            return -1;
        }
        return this.errorType.getExitCode();
    }

    @Override
    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void setCommandOutput(String commandOutput) {
        this.commandOutput = commandOutput;
        this.backendErrorMessage = this.commandOutput == null ? "" : this.parseErrorMessage();
        this.parseErrorResultMessage();
    }

    @Override
    public void makeException() throws CommandErrorException {
        String exceptionMessage = this.getMessage();
        if (this.errorType == null && StringUtil.isEmpty((CharSequence)exceptionMessage)) {
            throw new CommandErrorException(PkgcmdErrorMessages.ERROR_UNKNOWN);
        }
        if (!ErrorMessageType.SUCCESS.equals((Object)this.errorType)) {
            throw new CommandErrorException(this.errorType, exceptionMessage, this.errorMessage, this.errorCode);
        }
    }

    public String toString() {
        return this.getMessage();
    }

    private String parseErrorMessage() {
        int startIdx = this.commandOutput.indexOf(ERROR_MESSAGE_TEMPLATE);
        int endIdx = this.commandOutput.indexOf(System.getProperty("line.separator"), startIdx);
        if (startIdx == -1 || endIdx == -1) {
            return "";
        }
        return this.commandOutput.substring(startIdx + ERROR_MESSAGE_TEMPLATE.length(), endIdx).replaceAll("\\|", "\n");
    }
}

