/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.dlog;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.tizen.sdblib.dlog.DlogInfo;
import org.tizen.sdblib.dlog.IDlogParser;
import org.tizen.sdblib.util.LogLevel;
import org.tizen.sdblib.util.StringUtil;

public class DlogBriefParser
implements IDlogParser {
    private static final Pattern pattern = Pattern.compile("^([VDIWEFS])/.+\\(\\s*(\\d+)\\):\\s(.+)");

    @Override
    public DlogInfo[] parse(String ... lines) {
        ArrayList<DlogInfo> infos = new ArrayList<DlogInfo>();
        DlogInfo info = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] matches;
            String line = stringArray[n2];
            if (line.length() > 0 && (matches = StringUtil.split(line, pattern)) != null && matches.length == 3) {
                info = new DlogInfo();
                info.setLogLevel(LogLevel.getByLetter(matches[0]));
                info.setTag(matches[0]);
                info.setPid(Integer.parseInt(matches[1]));
                info.setCommand(matches[2]);
                infos.add(info);
            }
            ++n2;
        }
        return infos.toArray(new DlogInfo[0]);
    }
}

