/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.model.descriptors.io.file;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.efluibuilder.model.descriptors.io.DescriptorFileData;
import org.tizen.uibuilder.tizenfile.TizenFileDataEntry;
import org.tizen.uibuilder.tizenfile.TizenFileDataHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DescriptorReader_ver_1 {
    private static final String ELEM_RENDERER = "renderer";
    private static final String ELEM_FRAMEWORK = "framework";
    private static final String ELEM_LIBRARY = "library";
    private static final String ELEM_EDITOR = "editor";
    private static final String ELEM_DOC = "doc";
    private static final String ELEM_PAGE = "page";
    private static final String ELEM_WIDGET = "widget";
    private static final String ELEM_CONTENT = "content";
    private static final String ELEM_NOCONTENT = "nocontent";
    private static final String ELEM_PARENT = "parent";
    private static final String ELEM_NOPARENT = "noparent";
    private static final String ELEM_RELATIONS = "relations";
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_CONDITION = "condition";
    private static final String ELEM_EVENT = "event";
    private static final String ELEM_XSL_FOR_OUTPUT = "xsl-for-output";
    private static final String ELEM_TYPES = "types";
    private static final String ELEM_TYPE = "type";
    private static final String ELEM_CONSTANT = "constant";
    private static final String ELEM_UNIT = "unit";
    private static final String ELEM_EVENTTYPES = "eventTypes";
    private static final String ELEM_EVENTTYPE = "eventType";
    private static final String ELEM_DEFAULTCODE = "defaultCode";
    private static final String ELEM_PARAM = "param";
    private static final String ATTR_ID = "id";
    private static final String ATTR_DISPLAYNAME = "displayName";
    private static final String ATTR_SMALLICON = "smallIcon";
    private static final String ATTR_ICON_16 = "icon.16";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LAYOUTTYPE = "layoutType";
    private static final String ATTR_LAYOUT_CAPACITY = "layoutCapacity";
    private static final String ATTR_PALETTE_VISIBLE = "paletteVisible";
    private static final String ATTR_HELPCATEGORY = "helpCategory";
    private static final String ATTR_HELPCONTENS = "helpContents";
    private static final String ATTR_FEEDBACKWIDTH = "feedbackWidth";
    private static final String ATTR_FEEDBACKHEIGHT = "feedbackHeight";
    private static final String ATTR_MINWIDTH = "minWidth";
    private static final String ATTR_MINHEIGHT = "minHeight";
    private static final String ATTR_BORDER_VISIBLE = "borderVisible";
    private static final String ATTR_FEEDBACKCONDITION = "feedbackCondition";
    private static final String ATTR_GUIDE_TEXT = "guideText";
    private static final String ATTR_SET_STYLE = "setStyle";
    private static final String ATTR_UI_SELECTOR = "uiSelector";
    private static final String ATTR_XPATH = "xpath";
    private static final String ATTR_CHILDXPATH = "childXpath";
    private static final String ATTR_SELFCHILDXPATH = "selfChildXpath";
    private static final String ATTR_ATTRXPATH = "attrXpath";
    private static final String ATTR_INLINE = "inline";
    private static final String ATTR_IDS = "ids";
    private static final String ATTR_EXCLUDE_IDS = "exclude-ids";
    private static final String ATTR_PARENT_IDS = "parent-ids";
    private static final String ATTR_EXCLUSIVE_GROUP = "exclusiveGroup";
    private static final String ATTR_MIN = "min";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_INITVALUE = "initValue";
    private static final String ATTR_SELECTOR = "selector";
    private static final String ATTR_NOT_SUPPORTED = "notsupported";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_TARGETVALUE = "targetValue";
    private static final String ATTR_TOOLTIP = "tooltip";
    private static final String ATTR_ERROR = "error";
    private static final String ATTR_EVENTTYPE = "eventType";
    private static final String ATTR_SRC = "src";

    public static DescriptorFileData parse(URI uRI) throws ParserConfigurationException, SAXException, IOException {
        DescriptorFileData descriptorFileData = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(uRI.toString());
        if (documentBuilder != null && document != null && document.getDocumentElement() != null) {
            descriptorFileData = new DescriptorFileData();
            DescriptorReader_ver_1.parseRoot(descriptorFileData, document.getDocumentElement(), documentBuilder);
        }
        return descriptorFileData;
    }

    private static void parseRoot(DescriptorFileData descriptorFileData, Element element, DocumentBuilder documentBuilder) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (node.getNodeName().equals(ELEM_RENDERER)) {
                    DescriptorReader_ver_1.parseRenderer(descriptorFileData, ELEM_RENDERER, (Element)node);
                } else if (node.getNodeName().equals(ELEM_FRAMEWORK)) {
                    DescriptorReader_ver_1.parseFramework(descriptorFileData, ELEM_FRAMEWORK, (Element)node);
                } else if (node.getNodeName().equals(ELEM_DOC)) {
                    DescriptorReader_ver_1.parsePart(descriptorFileData, ELEM_DOC, (Element)node);
                } else if (node.getNodeName().equals(ELEM_PAGE)) {
                    DescriptorReader_ver_1.parsePart(descriptorFileData, ELEM_PAGE, (Element)node);
                } else if (node.getNodeName().equals(ELEM_WIDGET)) {
                    DescriptorReader_ver_1.parsePart(descriptorFileData, ELEM_WIDGET, (Element)node);
                } else if (node.getNodeName().equals(ELEM_TYPES)) {
                    DescriptorReader_ver_1.parseTypes(descriptorFileData, (Element)node);
                } else if (node.getNodeName().equals(ELEM_EVENTTYPES)) {
                    DescriptorReader_ver_1.parseEventTypes(descriptorFileData, (Element)node);
                }
            }
            ++n;
        }
    }

    private static void parseRenderer(DescriptorFileData descriptorFileData, String string, Element element) {
        if (element == null) {
            return;
        }
        String string2 = element.getAttribute(ATTR_ID);
        descriptorFileData.setRendererId(string2);
    }

    private static void parseFramework(DescriptorFileData descriptorFileData, String string, Element element) {
        if (element == null) {
            return;
        }
        String string2 = element.getAttribute(ATTR_NAME);
        descriptorFileData.setFrameworkName(string2);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (node.getNodeName().equals(ELEM_LIBRARY)) {
                    DescriptorReader_ver_1.parseLibrary(descriptorFileData, string, (Element)node);
                } else if (node.getNodeName().equals(ELEM_EDITOR)) {
                    DescriptorReader_ver_1.parseEditor(descriptorFileData, ELEM_EDITOR, (Element)node);
                }
            }
            ++n;
        }
    }

    private static void parseLibrary(DescriptorFileData descriptorFileData, String string, Element element) {
        if (string.equals(ELEM_FRAMEWORK)) {
            descriptorFileData.addFrameworkLibrary(element.getAttribute(ATTR_SRC));
        } else if (string.equals(ELEM_EDITOR)) {
            descriptorFileData.addEditorLibrary(element.getAttribute(ATTR_SRC));
        }
    }

    private static void parseEditor(DescriptorFileData descriptorFileData, String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(ELEM_LIBRARY);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            DescriptorReader_ver_1.parseLibrary(descriptorFileData, ELEM_EDITOR, element2);
            ++n;
        }
    }

    private static TizenFileDataEntry parsePart(DescriptorFileData descriptorFileData, String string, Element element) {
        TizenFileDataEntry tizenFileDataEntry;
        NodeList nodeList;
        Object object;
        TizenFileDataEntry tizenFileDataEntry2;
        String[] stringArray;
        String string2;
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry3 = TizenFileDataHelper.convert((String)string, (Element)element, (String[])new String[]{ATTR_ID, ATTR_DISPLAYNAME, ATTR_SMALLICON, ATTR_ICON_16, ATTR_DESCRIPTION, ATTR_LAYOUTTYPE, ATTR_LAYOUT_CAPACITY, ATTR_PALETTE_VISIBLE, ATTR_HELPCATEGORY, ATTR_HELPCONTENS, ATTR_FEEDBACKWIDTH, ATTR_FEEDBACKHEIGHT, ATTR_MINWIDTH, ATTR_MINHEIGHT, ATTR_BORDER_VISIBLE, ATTR_FEEDBACKCONDITION, ATTR_GUIDE_TEXT, ATTR_SET_STYLE, ATTR_UI_SELECTOR, ATTR_XPATH, ATTR_CHILDXPATH, ATTR_SELFCHILDXPATH});
        if (string.equals(ELEM_WIDGET) && (string2 = element.getAttribute(ATTR_CATEGORY)) != null && !string2.isEmpty()) {
            stringArray = string2.split(",");
            tizenFileDataEntry3.addListProperty("categoryList", Arrays.asList(stringArray));
        }
        boolean bl = true;
        stringArray = element.getElementsByTagName(ELEM_RELATIONS);
        int n = 0;
        while (n < stringArray.getLength()) {
            tizenFileDataEntry2 = DescriptorReader_ver_1.parseRelations((Element)stringArray.item(n));
            if (tizenFileDataEntry2 != null) {
                object = tizenFileDataEntry3.getEntryProperty("relation");
                if (object != null) {
                    object.addListPropertyList(ELEM_PARENT, tizenFileDataEntry2.getListProperty(ELEM_PARENT));
                    object.addListPropertyList(ELEM_NOPARENT, tizenFileDataEntry2.getListProperty(ELEM_NOPARENT));
                    object.addListPropertyList(ELEM_CONTENT, tizenFileDataEntry2.getListProperty(ELEM_CONTENT));
                    object.addListPropertyList(ELEM_NOCONTENT, tizenFileDataEntry2.getListProperty(ELEM_NOCONTENT));
                } else {
                    tizenFileDataEntry3.addEntryProperty("relation", tizenFileDataEntry2);
                }
                bl = false;
            }
            ++n;
        }
        if (bl && (nodeList = element.getElementsByTagName(ELEM_CONTENT)).getLength() > 0) {
            tizenFileDataEntry2 = new TizenFileDataEntry();
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                tizenFileDataEntry = DescriptorReader_ver_1.parseContent((Element)nodeList.item(n2));
                if (tizenFileDataEntry != null) {
                    String string3 = tizenFileDataEntry.getStringProperty(ATTR_EXCLUDE_IDS);
                    String[] stringArray2 = string3.split(",");
                    List<String> list = Arrays.asList(stringArray2);
                    tizenFileDataEntry2.addListPropertyList(ELEM_NOCONTENT, list);
                    String string4 = tizenFileDataEntry.getStringProperty(ATTR_PARENT_IDS);
                    stringArray2 = string4.split(",");
                    list = Arrays.asList(stringArray2);
                    tizenFileDataEntry2.addListPropertyList(ELEM_PARENT, list);
                }
                ++n2;
            }
            tizenFileDataEntry3.addEntryProperty("relation", tizenFileDataEntry2);
        }
        NodeList nodeList2 = element.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList2.getLength()) {
            object = nodeList2.item(n3);
            if (object instanceof Element) {
                if (object.getNodeName().equals(ELEM_CONDITION)) {
                    tizenFileDataEntry = DescriptorReader_ver_1.parsePartCondition((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("conditionList", (Object)tizenFileDataEntry);
                    }
                } else if (object.getNodeName().equals(ELEM_PROPERTY)) {
                    tizenFileDataEntry = DescriptorReader_ver_1.parseProperty((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("propertyList", (Object)tizenFileDataEntry);
                    }
                } else if (object.getNodeName().equals(ELEM_EVENT)) {
                    tizenFileDataEntry = DescriptorReader_ver_1.parseEvent((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("eventList", (Object)tizenFileDataEntry);
                    }
                } else if (object.getNodeName().equals(ELEM_XSL_FOR_OUTPUT) && (tizenFileDataEntry = DescriptorReader_ver_1.parseXsltForOutput((Element)object)) != null) {
                    descriptorFileData.addXslEntry(tizenFileDataEntry);
                }
            }
            ++n3;
        }
        descriptorFileData.addPartDescriptor(tizenFileDataEntry3);
        return tizenFileDataEntry3;
    }

    private static TizenFileDataEntry parseRelations(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = new TizenFileDataEntry();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                List<String> list;
                String[] stringArray;
                String string;
                Element element2 = (Element)node;
                if (node.getNodeName().equals(ELEM_PARENT)) {
                    string = element2.getAttribute(ATTR_IDS);
                    stringArray = string.split(",");
                    list = Arrays.asList(stringArray);
                    tizenFileDataEntry.addListPropertyList(ELEM_PARENT, list);
                } else if (node.getNodeName().equals(ELEM_NOPARENT)) {
                    string = element2.getAttribute(ATTR_IDS);
                    stringArray = string.split(",");
                    list = Arrays.asList(stringArray);
                    tizenFileDataEntry.addListPropertyList(ELEM_NOPARENT, list);
                } else if (node.getNodeName().equals(ELEM_CONTENT)) {
                    string = DescriptorReader_ver_1.parseContent2(element2);
                    tizenFileDataEntry.addListPropertyItem(ELEM_CONTENT, (Object)string);
                } else if (node.getNodeName().equals(ELEM_NOCONTENT)) {
                    string = element2.getAttribute(ATTR_IDS);
                    stringArray = string.split(",");
                    list = Arrays.asList(stringArray);
                    tizenFileDataEntry.addListPropertyList(ELEM_NOCONTENT, list);
                }
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseContent(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_EXCLUDE_IDS, ATTR_PARENT_IDS});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseContent2(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_IDS, "type", ATTR_MIN, ATTR_MAX, ATTR_EXCLUSIVE_GROUP});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parsePartCondition(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_VALUE, ATTR_TARGET, ATTR_TARGETVALUE});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseProperty(Element element) {
        TizenFileDataEntry tizenFileDataEntry;
        int n;
        NodeList nodeList;
        if (element == null) {
            return null;
        }
        String string = element.getAttribute(ATTR_NOT_SUPPORTED);
        if (string != null && string.equals("true")) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry2 = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "type", ATTR_DISPLAYNAME, ATTR_DEFAULT, ATTR_INITVALUE, ATTR_CATEGORY, ATTR_XPATH, ATTR_ATTRXPATH, ATTR_INLINE});
        String string2 = element.getAttribute("type");
        String string3 = element.getAttribute(ATTR_DISPLAYNAME);
        String string4 = element.getAttribute(ATTR_TOOLTIP);
        string4 = string4 == null ? string3 : String.valueOf(string3) + " " + "-" + " " + string4;
        tizenFileDataEntry2.addProperty(ATTR_TOOLTIP, (Object)string4);
        if ("group".equals(string2) || "group-text".equals(string2) || "group-position".equals(string2)) {
            nodeList = element.getElementsByTagName(ELEM_PROPERTY);
            n = 0;
            while (n < nodeList.getLength()) {
                tizenFileDataEntry = DescriptorReader_ver_1.parseChildProperty((Element)nodeList.item(n));
                if (tizenFileDataEntry != null) {
                    tizenFileDataEntry2.addListPropertyItem("propertyList", (Object)tizenFileDataEntry);
                }
                ++n;
            }
        }
        nodeList = element.getElementsByTagName(ELEM_CONDITION);
        n = 0;
        while (n < nodeList.getLength()) {
            tizenFileDataEntry = DescriptorReader_ver_1.parseCondition((Element)nodeList.item(n));
            if (tizenFileDataEntry != null) {
                tizenFileDataEntry2.addListPropertyItem("conditionList", (Object)tizenFileDataEntry);
            }
            ++n;
        }
        return tizenFileDataEntry2;
    }

    private static TizenFileDataEntry parseChildProperty(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "type", ATTR_DISPLAYNAME, ATTR_TOOLTIP, ATTR_DEFAULT, ATTR_INITVALUE, ATTR_CATEGORY, ATTR_XPATH, ATTR_ATTRXPATH, ATTR_SELECTOR});
        NodeList nodeList = element.getElementsByTagName(ELEM_CONDITION);
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry2 = DescriptorReader_ver_1.parseCondition((Element)nodeList.item(n));
            if (tizenFileDataEntry2 != null) {
                tizenFileDataEntry.addListPropertyItem("conditionList", (Object)tizenFileDataEntry2);
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseCondition(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_VALUE, ATTR_TARGET, ATTR_TARGETVALUE, ATTR_ERROR});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseEvent(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_DISPLAYNAME, "eventType"});
        return tizenFileDataEntry;
    }

    private static void parseTypes(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName("type");
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry = DescriptorReader_ver_1.parseType((Element)nodeList.item(n));
            descriptorFileData.addType(tizenFileDataEntry);
            ++n;
        }
    }

    private static TizenFileDataEntry parseType(Element element) {
        TizenFileDataEntry tizenFileDataEntry;
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry2 = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_ID});
        NodeList nodeList = element.getElementsByTagName(ELEM_CONSTANT);
        int n = 0;
        while (n < nodeList.getLength()) {
            tizenFileDataEntry = DescriptorReader_ver_1.parseConstant((Element)nodeList.item(n));
            tizenFileDataEntry2.addListPropertyItem("constantList", (Object)tizenFileDataEntry);
            ++n;
        }
        nodeList = element.getElementsByTagName(ELEM_UNIT);
        n = 0;
        while (n < nodeList.getLength()) {
            tizenFileDataEntry = DescriptorReader_ver_1.parseUnit((Element)nodeList.item(n));
            tizenFileDataEntry2.addListPropertyItem("unitList", (Object)tizenFileDataEntry);
            ++n;
        }
        return tizenFileDataEntry2;
    }

    private static TizenFileDataEntry parseConstant(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_VALUE, ATTR_DISPLAYNAME, ATTR_ICON});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseUnit(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_VALUE, ATTR_DISPLAYNAME});
        return tizenFileDataEntry;
    }

    private static void parseEventTypes(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName("eventType");
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry = DescriptorReader_ver_1.parseEventType(descriptorFileData, (Element)nodeList.item(n));
            if (tizenFileDataEntry != null) {
                descriptorFileData.addEventType(tizenFileDataEntry);
            }
            ++n;
        }
    }

    private static TizenFileDataEntry parseEventType(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_ID});
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals(ELEM_DEFAULTCODE)) {
                    tizenFileDataEntry.addStringProperty(ELEM_DEFAULTCODE, element2.getTextContent());
                } else if (node.getNodeName().equals(ELEM_PARAM)) {
                    tizenFileDataEntry.addListPropertyItem("paramList", (Object)DescriptorReader_ver_1.parseParameter(element2));
                }
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseParameter(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "type"});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseXsltForOutput(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = new TizenFileDataEntry();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                tizenFileDataEntry.addListPropertyItem("xslList", (Object)node);
            }
            ++n;
        }
        return tizenFileDataEntry;
    }
}

