/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.codewriter;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FreeMarkerUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.efluibuilder.projectmigrator.Activator;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterConstants;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterException;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;
import org.tizen.efluibuilder.projectmigrator.util.FileUtil;

public class UserViewGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IProject project;

    public UserViewGenerator(IProject iProject) {
        this.project = iProject;
    }

    public void addUserViewFile(List<String> list, int n, IProgressMonitor iProgressMonitor) throws CodeWriterException {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n2 = n / list.size();
        int n3 = n;
        Template template = null;
        try {
            Configuration object = FreeMarkerUtil.getConfiguration((AbstractUIPlugin)Activator.getDefault(), (String)"/res/template");
            template = object.getTemplate("user_view");
        }
        catch (IOException iOException) {
            this.logger.error(iOException.getMessage());
            throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.error(uRISyntaxException.getMessage());
            throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
        }
        for (String string : list) {
            IFile iFile = FileUtil.getFile(this.project, CodeWriterConstants.USER_VIEW_PATH, "uib_" + string + "_view.c");
            if (iFile.exists()) continue;
            this.createFile(iFile, this.getUserViewByteArray(template, string));
            iProgressMonitor.worked(n2);
            iProgressMonitor.subTask(Messages.bind((String)Messages.PROGRESS_MSG_SUBTASK_DO_PROCESS_USER_VIEW_FILE, (Object)string.toUpperCase()));
            n3 -= n2;
            if (!iProgressMonitor.isCanceled()) continue;
            return;
        }
        iProgressMonitor.worked(n3);
    }

    public void deleteUserviewFile(List<String> list, int n, IProgressMonitor iProgressMonitor) throws CodeWriterException {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n2 = n / list.size();
        int n3 = n;
        for (String string : list) {
            IFile iFile = FileUtil.getFile(this.project, CodeWriterConstants.USER_VIEW_PATH, "uib_" + string + "_view.c");
            if (iFile.exists()) {
                try {
                    iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    this.logger.error(coreException.getMessage());
                    throw new CodeWriterException(Messages.bind((String)Messages.CORE_EXCEPTION_MSG_DELETE_FILE, (Object)iFile.getLocation().toOSString()));
                }
            }
            iProgressMonitor.worked(n2);
            iProgressMonitor.subTask(Messages.bind((String)Messages.PROGRESS_MSG_SUBTASK_DO_PROCESS_USER_VIEW_FILE, (Object)string.toUpperCase()));
            n3 -= n2;
            if (!iProgressMonitor.isCanceled()) continue;
            return;
        }
        iProgressMonitor.worked(n3);
    }

    private byte[] getUserViewByteArray(Template template, String string) throws CodeWriterException {
        if (template == null || string == null || string.isEmpty()) {
            return null;
        }
        byte[] byArray = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("user_view_name", string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        try {
            try {
                template.process(hashMap, (Writer)outputStreamWriter);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (TemplateException templateException) {
                this.logger.error(templateException.getMessage());
                throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
            }
            catch (IOException iOException) {
                this.logger.error(iOException.getMessage());
                throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{byteArrayOutputStream});
            IOUtil.tryClose((Object[])new Object[]{outputStreamWriter});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{byteArrayOutputStream});
        IOUtil.tryClose((Object[])new Object[]{outputStreamWriter});
        return byArray;
    }

    private void createFile(IFile iFile, byte[] byArray) throws CodeWriterException {
        if (iFile == null || byArray == null) {
            return;
        }
        try {
            iFile.create((InputStream)new ByteArrayInputStream(byArray), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage());
            throw new CodeWriterException(Messages.bind((String)Messages.CORE_EXCEPTION_MSG_CREATE_FILE, (Object)iFile.getLocation().toOSString()));
        }
    }
}

