<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">

	<xsl:template match="*" mode="panel.content.set">
		<xsl:param name="parent" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name()='variation'" />
			<xsl:otherwise>
				<!-- <xsl:value-of select="concat($indentation, 'evas_object_show(vc->', @id,');', $newline)" /> -->
				<xsl:value-of select="concat($indentation,'elm_object_content_set(vc->', $parent,', ','vc->',@id,');', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="panel">
		<xsl:param name="parent" />
		<xsl:param name="fromView" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="profile" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$fromView = 'true'">
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_panel_add(parent);', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->root_container = vc->', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string-length($fromView) = 0">
					<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
					<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_panel_add(vc->', $parent, ');', $newline)" />
					<xsl:value-of select="concat($indentation,'}', $newline)" />
				</xsl:if>
				<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

				<xsl:call-template name="size_hint_align_set">
					<xsl:with-param name="align_h" select="@align_h" />
					<xsl:with-param name="align_v" select="@align_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>

				<xsl:call-template name="size_hint_weight_set">
					<xsl:with-param name="weight_h" select="@weight_h" />
					<xsl:with-param name="weight_v" select="@weight_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>

				<xsl:if test="string-length(@orient) != 0">
					<xsl:variable name="rconv_key" select="concat('panel:orient', ':', @orient)" />
					<xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
					<xsl:choose>
						<xsl:when test="string-length($rconv_value) != 0">
							<xsl:value-of select="concat($indentation1, 'elm_panel_orient_set(vc->', @id, ', ', $rconv_value, ');', $newline)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($indentation1, 'elm_panel_orient_set(vc->', @id, ', ', @orient, ');', $newline)" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>

				<xsl:if test="string-length(@hidden) != 0">
					<xsl:choose>
						<xsl:when test="@hidden='true'">
							<xsl:value-of select="concat($indentation1,'elm_panel_hidden_set(vc->', @id, ', EINA_TRUE);', $newline)" />
						</xsl:when>
						<xsl:otherwise>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>

				<xsl:apply-templates select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
					<xsl:with-param name="profile" select="$profile" />
				</xsl:apply-templates>

				<xsl:apply-templates mode="panel.content.set" select="*">
					<xsl:with-param name="parent" select="@id" />
				</xsl:apply-templates>
				<xsl:if test="@disable = 'true'">
					<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:if>
				<xsl:apply-templates mode="visible" select="current()">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
				</xsl:apply-templates>
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
