<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="toolbaritem">
		<xsl:param name="parent" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation2">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+2" />
			</xsl:call-template>
		</xsl:param>
		<xsl:variable name="callback">
			<xsl:apply-templates select="event" mode="item_event">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="view" select="./ancestor::view/@id" />
				<!-- Storyboard_START -->
				<xsl:with-param name="target" select="event/@target" />
				<!-- Storyboard_END -->
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($callback) != 0">
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_toolbar_item_append(vc->', $parent, ', NULL, _UIB_LOCALE(&quot;', @label, '&quot;), (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_toolbar_item_append(vc->', $parent, ', NULL, _UIB_LOCALE(&quot;', @text, '&quot;), (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_toolbar_item_append(vc->', $parent, ', NULL, _UIB_LOCALE(&quot;', @label, '&quot;), NULL, NULL);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_toolbar_item_append(vc->', $parent, ', NULL, _UIB_LOCALE(&quot;', @text, '&quot;), NULL, NULL);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="string-length(@src) != 0">
			<xsl:variable name="escapedSrc">
				<xsl:call-template name="escapeStr">
					<xsl:with-param name="str" select="@src" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="concat($indentation, 'char *', @id, '_resource_path = NULL;', $newline)" />
			<xsl:choose>
				<xsl:when test="$is_version_rm_support='true'">
					<xsl:value-of
						select="concat($indentation1, 'uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, &quot;', $escapedSrc, '&quot;, &amp;', @id, '_resource_path);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(-1, &quot;', $escapedSrc, '&quot;, &amp;', @id, '_resource_path);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="concat($indentation, 'elm_toolbar_item_icon_set(vc->', @id, ', ', @id, '_resource_path);', $newline)" />
			<xsl:value-of select="concat($indentation, 'if(', @id, '_resource_path) {', $newline)" />
			<xsl:value-of select="concat($indentation1, 'free(', @id, '_resource_path);', $newline)" />
			<xsl:value-of select="concat($indentation, '}', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@selected) != 0">
			<xsl:choose>
				<xsl:when test="@selected = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_toolbar_item_selected_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_toolbar_item_selected_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="string-length(@disable) != 0">
			<xsl:choose>
				<xsl:when test="@disable = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_object_item_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_object_item_disabled_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
