<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="dup">
		<xsl:param name="input" />
		<xsl:param name="count" select="2" />
		<xsl:choose>
			<xsl:when test="not($count) or not($input)" />
			<xsl:when test="$count = 1">
				<xsl:value-of select="$input" />
			</xsl:when>
			<xsl:otherwise>
				<!-- If $count is odd append an extra copy of input -->
				<xsl:if test="$count mod 2">
					<xsl:value-of select="$input" />
				</xsl:if>
				<!-- Recursively apply template after doubling input and halving count -->
				<xsl:call-template name="dup">
					<xsl:with-param name="input" select="concat($input,$input)" />
					<xsl:with-param name="count" select="floor($count div 2)" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="search-and-replace">
		<xsl:param name="input" />
		<xsl:param name="search-string" />
		<xsl:param name="replace-string" />
		<xsl:choose>
			<!-- See if the input contains the search string -->
			<xsl:when test="$search-string and 
                           contains($input,$search-string)">
				<!-- If so, then concatenate the substring before the search string to the replacement string and to the result of recursively applying this template to the 
					remaining substring. -->
				<xsl:value-of select="substring-before($input,$search-string)" />
				<xsl:value-of select="$replace-string" />
				<xsl:call-template name="search-and-replace">
					<xsl:with-param name="input" select="substring-after($input,$search-string)" />
					<xsl:with-param name="search-string" select="$search-string" />
					<xsl:with-param name="replace-string" select="$replace-string" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- There are no more occurrences of the search string so just return the current input string -->
				<xsl:value-of select="$input" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="size_hint_align_set">
		<xsl:param name="align_h" />
		<xsl:param name="align_v" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />

		<xsl:if test="string-length($align_h) != 0 and string-length($align_v) != 0">
			<xsl:variable name="x">
				<xsl:choose>
					<xsl:when test="$align_h='fill'">
						<xsl:value-of select='format-number(-1, "#.0")' />
					</xsl:when>
					<xsl:when test="$align_v='left'">
						<xsl:value-of select='format-number(0, "#.0")' />
					</xsl:when>
					<xsl:when test="$align_v='center'">
						<xsl:value-of select='format-number(0.5, "#.0")' />
					</xsl:when>
					<xsl:when test="$align_v='right'">
						<xsl:value-of select='format-number(1, "#.0")' />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$align_h" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="y">
				<xsl:choose>
					<xsl:when test="$align_v='fill'">
						<xsl:value-of select='format-number(-1, "#.0")' />
					</xsl:when>
					<xsl:when test="$align_v='top'">
						<xsl:value-of select='format-number(0, "#.0")' />
					</xsl:when>
					<xsl:when test="$align_v='center'">
						<xsl:value-of select='format-number(0.5, "#.0")' />
					</xsl:when>
					<xsl:when test="$align_v='bottom'">
						<xsl:value-of select='format-number(1, "#.0")' />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$align_v" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_align_set(vc->', $id, ', ', $x, ', ' , $y, ');', '&#xD;')" />
		</xsl:if>

	</xsl:template>

	<xsl:template name="size_hint_weight_set">
		<xsl:param name="weight_h" />
		<xsl:param name="weight_v" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />

		<xsl:if test="string-length($weight_h) != 0 and string-length($weight_v) != 0">
			<xsl:variable name="x">
				<xsl:choose>
					<xsl:when test="$weight_h='expand'">
						<xsl:value-of select='format-number(-1, "#.0")' />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select='format-number($weight_h, "#.0")' />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="y">
				<xsl:choose>
					<xsl:when test="$weight_v='expand'">
						<xsl:value-of select='format-number(-1, "#.0")' />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select='format-number($weight_v, "#.0")' />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_weight_set(vc->', $id, ', ', $x, ', ' , $y, ');', '&#xD;')" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="function_call3">
		<xsl:param name="function_name" />
		<xsl:param name="param1" />
		<xsl:param name="param2" />
		<xsl:param name="param3" />
		<xsl:value-of select="$function_name" />
		<xsl:text>(</xsl:text>
		<xsl:value-of select="$param1" />
		<xsl:text>, </xsl:text>
		<xsl:value-of select="$param2" />
		<xsl:text>, </xsl:text>
		<xsl:value-of select="$param3" />
		<xsl:text>);</xsl:text>
	</xsl:template>

	<xsl:template name="eina_bool">
		<xsl:param name="bool" />
		<xsl:choose>
			<xsl:when test="$bool = 'true'">
				<xsl:value-of select="'EINA_TRUE'" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'EINA_FALSE'" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="disable">
		<xsl:param name="disable" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:if test="string-length($disable) != 0"><!-- default: false -->
			<xsl:choose>
				<xsl:when test="$disable = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_object_disabled_set(vc->', $id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_object_disabled_set(vc->', $id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template match="*" mode="visible">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="count(./variation[@config_ref=$view_configuration_id]) > 0">
				<xsl:for-each select="./variation[@config_ref=$view_configuration_id]">
					<xsl:choose>
						<xsl:when test="@visible = 'false'">
							<xsl:value-of select="concat($indentation1, 'evas_object_hide(vc->', $parent, ');',$newline)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($indentation1, 'evas_object_show(vc->', $parent, ');',$newline)" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@visible = 'false'">
						<xsl:value-of select="concat($indentation1, 'evas_object_hide(vc->', $parent, ');',$newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($indentation1, 'evas_object_show(vc->', $parent, ');',$newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="style">
		<xsl:param name="style" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:if test="string-length($style) != 0">
			<xsl:value-of select="concat($indentation, 'elm_object_style_set(vc->', $id, ',', '&quot;', $style, '&quot;', ');', $newline)" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="colors">
		<xsl:param name="colors" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:param name="widgettype" />
		<xsl:if test="string-length($colors) != 0">
			<xsl:variable name="colorpick"
				select="normalize-space(substring-before($colors, ';'))" />
			<xsl:if test="string-length($colorpick)!= 0">
				<xsl:variable name="colorclass"
					select="normalize-space(substring-before($colorpick, ':'))" />
				<xsl:variable name="colorname"
					select="normalize-space(substring-after($colorpick, ':'))" />
				<xsl:value-of
					select="concat($indentation, 'int ', $id, '_',$colorclass,'_hexValue = strtol(&quot;', $colorname, '&quot;+1, NULL, 16);', $newline)" />
				<xsl:value-of disable-output-escaping="yes"
					select="concat($indentation, 'int ', $id, '_',$colorclass,'_r = (', $id, '_',$colorclass,'_hexValue', '&amp;', '0xFF0000)', '&gt;&gt;', '16;', $newline)" />
				<xsl:value-of disable-output-escaping="yes"
					select="concat($indentation, 'int ', $id, '_',$colorclass,'_g = (', $id, '_',$colorclass,'_hexValue', '&amp;', '0xFF00)', '&gt;&gt;', '8;', $newline)" />
				<xsl:value-of disable-output-escaping="yes"
					select="concat($indentation, 'int ', $id, '_',$colorclass,'_b = (', $id, '_',$colorclass,'_hexValue', '&amp;', '0xFF);', $newline)" />
				<xsl:choose>
				<xsl:when test="string-length($widgettype)!= 0">
					<xsl:value-of
						select="concat($indentation, 'elm_object_item_color_class_color_set(vc->', $id, ',', '&quot;', $colorclass, '&quot;', ', ', $id, '_',$colorclass,'_r, ', $id, '_',$colorclass,'_g, ', $id, '_',$colorclass,'_b, 255);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="concat($indentation, 'elm_object_color_class_color_set(vc->', $id, ',', '&quot;', $colorclass, '&quot;', ', ', $id, '_',$colorclass,'_r, ', $id, '_',$colorclass,'_g, ', $id, '_',$colorclass,'_b, 255);', $newline)" />
				</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:for-each select=".">
				<xsl:call-template name="colors">
					<xsl:with-param name="colors"
						select="normalize-space(substring-after($colors, ';'))" />
					<xsl:with-param name="indentation" select="$indentation" />
					<xsl:with-param name="id" select="$id" />
					<xsl:with-param name="widgettype" select="$widgettype" />

				</xsl:call-template>
			</xsl:for-each>

		</xsl:if>
	</xsl:template>

    <!-- This is intended to escape backslash('\') to double backslash('\\') for file path -->
    <xsl:template name="escapeStr">
        <xsl:param name="str" select="."/>
        <xsl:choose>
            <xsl:when test="contains($str, '\')">
                <xsl:value-of select="concat(substring-before($str, '\'), '\\' )"/>
                <xsl:call-template name="escapeStr">
                    <xsl:with-param name="str" select="substring-after($str, '\')"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$str"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>