<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="event/@*">
		<xsl:param name="level" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="view" />
		<xsl:param name="parent" />
		<xsl:variable name="signal">
			<xsl:value-of select="concat('&quot;', substring-after(name(.), 'on'), '&quot;')" />
		</xsl:variable>

		<xsl:if test="starts-with(name(.), 'on')">
			<xsl:value-of select="concat($indentation, 'void ', $view, '_', ., '(uib_' , $view, '_view_context*, Evas_Object*, void*);', $newline)" />
			<xsl:value-of select="concat($indentation, 'evas_object_smart_callback_add(vc->', $parent, ', ' , $signal ,', (Evas_Smart_Cb)', $view, '_', . , ', vc);', $newline)" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="event" mode="event.view.declaration">
		<xsl:param name="level" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="view" />
		<xsl:param name="parent" />

		<xsl:if test="string-length(@signal)!=0">
			<xsl:value-of select="concat($indentation, 'void ', @function_name, '(uib_' , $view, '_view_context*, Evas_Object*, void*);', $newline)" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="event" mode="registration">
		<xsl:param name="parent" />
		<xsl:param name="view" />

		<xsl:if test="string-length(@signal)!=0 and @signal!='itemselected'">
			<xsl:value-of
				select="concat($indent, 'evas_object_smart_callback_add(vc->', $parent, ', ' , '&#34;', @signal , '&#34;', ', (Evas_Smart_Cb)', @function_name, ', vc);')" />
			<xsl:value-of select="$newline" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="event" mode="item_event">
		<!-- Storyboard_START -->
		<xsl:choose>
			<xsl:when test="string-length(@target)=0">
				<xsl:if test="@signal='itemselected'">
					<xsl:value-of select="concat(@function_name)" />
				</xsl:if>
			</xsl:when>
			<xsl:when test="string-length(@connection_wrapper)!=0 and @signal='itemselected'">
				<xsl:value-of select="concat(@connection_wrapper)" />
			</xsl:when>
		</xsl:choose>
		<!-- Storyboard_END -->
	</xsl:template>

	<!-- Storyboard_START -->
	<xsl:template match="event" mode="event.wrapper.declaration">
		<xsl:param name="level" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="view" />
		<xsl:choose>
			<xsl:when test="string-length(@target)=0">
				<xsl:if test="string-length(@signal)!=0">
					<xsl:value-of select="concat($indentation, 'void ', @function_name, '(uib_' , $view, '_view_context*, Evas_Object*, void*);', $newline)" />
				</xsl:if>
			</xsl:when>
			<xsl:when test="string-length(@connection_wrapper)!=0">
				<xsl:value-of select="concat($indentation, 'void ', @connection_wrapper, '(uib_' , $view, '_view_context*, Evas_Object*, void*);', $newline)" />
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="event" mode="event.wrapper.registration">
		<xsl:param name="parent" />
		<xsl:param name="view" />
		<xsl:variable name="event">
			<xsl:value-of select="concat('&quot;',@signal,'&quot;')"></xsl:value-of>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length(@target)=0">
				<xsl:if test="string-length(@signal)!=0 and @signal!='itemselected'">
					<xsl:value-of select="concat($indent, 'evas_object_smart_callback_add(vc->', $parent, ', ' , $event, ', (Evas_Smart_Cb)', @function_name, ', vc);')" />
					<xsl:value-of select="$newline" />
				</xsl:if>
			</xsl:when>
			<xsl:when test="string-length(@connection_wrapper)!=0 and @signal !='itemselected'">
				<xsl:value-of select="concat($indent,'evas_object_smart_callback_add(vc->', $parent, ', ' , $event ,', (Evas_Smart_Cb)', @connection_wrapper, ', vc);')" />
				<xsl:value-of select="$newline" />
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- Storyboard_END -->

</xsl:stylesheet>
