/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.model.descriptors;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.efluibuilder.model.descriptors.EventTypeDescriptor;
import org.tizen.efluibuilder.model.descriptors.TypeDescriptor;
import org.tizen.efluibuilder.model.descriptors.WidgetDescriptor;
import org.tizen.efluibuilder.model.descriptors.io.AnalisysDescriptorFileData;
import org.tizen.efluibuilder.model.descriptors.io.DescriptorFileData;
import org.tizen.efluibuilder.model.descriptors.io.file.DescriptorReader;
import org.tizen.efluibuilder.utility.ResourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class DescriptorManager {
    private List<WidgetDescriptor> docs = new ArrayList<WidgetDescriptor>();
    private List<WidgetDescriptor> pages = new ArrayList<WidgetDescriptor>();
    private List<WidgetDescriptor> widgets = new ArrayList<WidgetDescriptor>();
    private Map<String, WidgetDescriptor> descriptorIds = new HashMap<String, WidgetDescriptor>();
    private Map<String, TypeDescriptor> types = new HashMap<String, TypeDescriptor>();
    private Map<String, EventTypeDescriptor> eventTypes = new HashMap<String, EventTypeDescriptor>();
    private Map<String, List<WidgetDescriptor>> categories = new LinkedHashMap<String, List<WidgetDescriptor>>();
    private List<String> defaultStyleEDJs = new ArrayList<String>();
    private Document xslt;
    private Element xslRoot;

    public void load(String string) throws IOException, ParserConfigurationException, SAXException {
        ResourceUtil.getURI((String)"org.tizen.efluibuilder.descriptor", (String)string);
        URI uRI = ResourceUtil.getURI((String)"org.tizen.efluibuilder.descriptor", (String)(String.valueOf(string) + "/tizen-native-ui-fw.xml"));
        this.load(uRI);
    }

    private void load(URI uRI) throws ParserConfigurationException, SAXException, IOException {
        this.addTypeDescriptor(new TypeDescriptor("string"));
        this.addTypeDescriptor(new TypeDescriptor("rm_string"));
        this.addTypeDescriptor(new TypeDescriptor("boolean"));
        this.addTypeDescriptor(new TypeDescriptor("integer"));
        this.addTypeDescriptor(new TypeDescriptor("double"));
        this.addTypeDescriptor(new TypeDescriptor("url"));
        this.addTypeDescriptor(new TypeDescriptor("image"));
        this.addTypeDescriptor(new TypeDescriptor("layout-resource"));
        this.addTypeDescriptor(new TypeDescriptor("text-resource"));
        this.addTypeDescriptor(new TypeDescriptor("color"));
        this.addTypeDescriptor(new TypeDescriptor("color2"));
        this.addTypeDescriptor(new TypeDescriptor("date"));
        this.addTypeDescriptor(new TypeDescriptor("time"));
        this.addTypeDescriptor(new TypeDescriptor("audio"));
        this.addTypeDescriptor(new TypeDescriptor("video"));
        this.addTypeDescriptor(new TypeDescriptor("htmlstring"));
        this.addTypeDescriptor(new TypeDescriptor("group"));
        this.addTypeDescriptor(new TypeDescriptor("group-text"));
        this.addTypeDescriptor(new TypeDescriptor("group-position"));
        this.addTypeDescriptor(new TypeDescriptor("css-text-align"));
        this.addTypeDescriptor(new TypeDescriptor("css-font-weight"));
        this.addTypeDescriptor(new TypeDescriptor("css-font-style"));
        this.addTypeDescriptor(new TypeDescriptor("css-text-decoration"));
        this.addTypeDescriptor(new TypeDescriptor("css-color"));
        this.addTypeDescriptor(new TypeDescriptor("size"));
        this.addTypeDescriptor(new TypeDescriptor("size@px"));
        this.addTypeDescriptor(new TypeDescriptor("size@deg"));
        this.addTypeDescriptor(new TypeDescriptor("size@per"));
        this.addTypeDescriptor(new TypeDescriptor("font@size"));
        this.addTypeDescriptor(new TypeDescriptor("text@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("value@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("foreach@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("slider@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("textchecked@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("foreachtext@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("valuetext@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("attrsrc@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("attrtext@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("attrhref@databinding"));
        this.addTypeDescriptor(new TypeDescriptor("opacity"));
        this.addTypeDescriptor(new TypeDescriptor("icon"));
        this.addTypeDescriptor(new TypeDescriptor("group-transform"));
        this.addTypeDescriptor(new TypeDescriptor("group-border"));
        this.addTypeDescriptor(new TypeDescriptor("separator"));
        this.addTypeDescriptor(new TypeDescriptor("check"));
        this.addTypeDescriptor(new TypeDescriptor("new-color"));
        this.addTypeDescriptor(new TypeDescriptor("color-fill"));
        this.addTypeDescriptor(new TypeDescriptor("scale"));
        this.addTypeDescriptor(new TypeDescriptor("scale@px"));
        this.addTypeDescriptor(new TypeDescriptor("scale@per"));
        this.addTypeDescriptor(new TypeDescriptor("scale@deg"));
        this.addTypeDescriptor(new TypeDescriptor("check-scale"));
        this.addTypeDescriptor(new TypeDescriptor("scale-integer"));
        this.addTypeDescriptor(new TypeDescriptor("group-filter"));
        this.addTypeDescriptor(new TypeDescriptor("group-value"));
        this.addTypeDescriptor(new TypeDescriptor("metrics"));
        this.addTypeDescriptor(new TypeDescriptor("empty"));
        this.addTypeDescriptor(new TypeDescriptor("custom-css"));
        this.addTypeDescriptor(new TypeDescriptor("clip"));
        this.addTypeDescriptor(new TypeDescriptor("group-icon"));
        this.addTypeDescriptor(new TypeDescriptor("item-add"));
        this.addTypeDescriptor(new TypeDescriptor("dynamic-combo"));
        DescriptorFileData descriptorFileData = DescriptorReader.parse(uRI);
        AnalisysDescriptorFileData.analisysFileData(this, descriptorFileData);
    }

    public void setXsltDocument(Document document) {
        this.xslt = document;
        if (this.xslt != null) {
            this.xslRoot = (Element)this.xslt.getChildNodes().item(0);
        }
    }

    public Document getXsltDocument() {
        return this.xslt;
    }

    public Element getXsltElement() {
        return this.xslRoot;
    }

    public void addPartDescriptor(WidgetDescriptor widgetDescriptor) {
        WidgetDescriptor widgetDescriptor2;
        if (widgetDescriptor == null) {
            return;
        }
        if (widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.WIDGET) {
            this.widgets.add(widgetDescriptor);
        } else if (widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.PAGE) {
            this.pages.add(widgetDescriptor);
        } else if (widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.DOC) {
            this.docs.add(widgetDescriptor);
        } else assert (false);
        this.descriptorIds.put(widgetDescriptor.getDescriptorId(), widgetDescriptor);
        if (widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.WIDGET && (widgetDescriptor2 = widgetDescriptor).getCategories() != null) {
            List<String> list = widgetDescriptor2.getCategories();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                String string = list.get(n2);
                List<WidgetDescriptor> list2 = this.categories.get(string);
                if (list2 == null) {
                    list2 = new ArrayList<WidgetDescriptor>();
                    this.categories.put(string, list2);
                }
                list2.add(widgetDescriptor2);
                ++n2;
            }
        }
    }

    public void addTypeDescriptor(TypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            return;
        }
        this.types.put(typeDescriptor.getId(), typeDescriptor);
    }

    public void addEventTypeDescriptor(EventTypeDescriptor eventTypeDescriptor) {
        if (eventTypeDescriptor == null) {
            return;
        }
        this.eventTypes.put(eventTypeDescriptor.getId(), eventTypeDescriptor);
    }

    public void addUIComponentCategoryDescriptor(String string) {
        if (string == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.categories.put(string, arrayList);
    }

    public void addDefaultStyleEDJ(String string) {
        if (string == null) {
            return;
        }
        this.defaultStyleEDJs.add(string);
    }

    public void addDescriptor(String string) {
        if (string == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.categories.put(string, arrayList);
    }

    public List<WidgetDescriptor> getDocumentDescriptors() {
        return this.docs;
    }

    public List<WidgetDescriptor> getPageDescriptors() {
        return this.pages;
    }

    public List<WidgetDescriptor> getWidgetDescriptors() {
        return this.widgets;
    }

    public Collection<String> getWidgetCategories() {
        return this.categories.keySet();
    }

    public List<WidgetDescriptor> getWidgetDescriptorsOfCategory(String string) {
        return this.categories.get(string);
    }

    public WidgetDescriptor getWidgetDescriptor(String string) {
        return this.descriptorIds.get(string);
    }

    public TypeDescriptor getTypeDescriptor(String string) {
        return this.types.get(string);
    }

    public EventTypeDescriptor getEventTypeDescriptor(String string) {
        return this.eventTypes.get(string);
    }

    public List<String> getDefaultStyleEDJs() {
        return this.defaultStyleEDJs;
    }
}

