/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.IOException;
import java.io.OutputStream;
import org.tizen.efluibuilder.internal.connector.ChecksumValidator;
import org.tizen.efluibuilder.internal.connector.Header;
import org.tizen.efluibuilder.internal.connector.IMessage;

public final class MessageWriter {
    private OutputStream stream = null;

    public MessageWriter(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void write(IMessage iMessage) throws IOException {
        byte[] byArray = iMessage.serialize();
        Header header = this.createHeader(byArray);
        byte[] byArray2 = header.serialize();
        this.write(byArray2);
        this.write(byArray);
    }

    private Header createHeader(byte[] byArray) {
        Header header = new Header();
        header.setId("NUIB");
        header.setVersion(1);
        header.setBodySize(byArray.length);
        int n = ChecksumValidator.createChecksum(byArray);
        header.setChecksum(n);
        header.setFormat(0);
        return header;
    }

    private void write(byte[] byArray) throws IOException {
        this.stream.write(byArray, 0, byArray.length);
        this.stream.flush();
    }
}

