<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="flipselectoritem">
		<xsl:param name="parent" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:apply-templates select="*">
			<xsl:with-param name="indentation" select="$indentation" />
			<xsl:with-param name="parent" select="$parent" />
		</xsl:apply-templates>
		<xsl:choose>
			<xsl:when test="@label">
				<xsl:value-of
					select="concat($indentation, 'vc->', @id, ' = elm_flipselector_item_append(vc->', $parent, ', _UIB_LOCALE(&quot;', @label, '&quot;), ', 'NULL, NULL);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of
					select="concat($indentation, 'vc->', @id, ' = elm_flipselector_item_append(vc->', $parent, ', _UIB_LOCALE(&quot;', @text, '&quot;), ', 'NULL, NULL);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="string-length(@selected) != 0">
			<xsl:choose>
				<xsl:when test="@selected = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_list_item_selected_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_list_item_selected_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

	</xsl:template>
</xsl:stylesheet>
