/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.ui.wizards.pages;

import java.util.ArrayList;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.util.DialogUtil;
import org.tizen.efluibuilder.projectmigrator.codewriter.ASTManager;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterConstants;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterException;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.FuncCallParamGetVisitor;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.ProjectMigratorWizard;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.BaseWizardPage;
import org.tizen.efluibuilder.projectmigrator.util.FileUtil;
import org.tizen.efluibuilder.projectmigrator.util.StringUtil;
import org.tizen.efluibuilder.projectmigrator.util.UIUtil;

public class UserViewPage
extends BaseWizardPage {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List list;
    private Text inputText;
    private Button btnAdd;
    private Button btnDelete;
    private Button btnStartUp;
    private ArrayList<String> currentUserViews = new ArrayList();
    private ArrayList<String> prevUserViews = new ArrayList();
    private ArrayList<String> deletedUserViews = new ArrayList();
    private static final int LIST_HEIGHT_SIZE = 250;
    private static final int INPUT_TEXT_MAX_LEN = 31;
    private static String UNICODENUM_STARTUP = "\u27aa";
    private static final String UNICODECH_STARTUPVIEW = " " + StringEscapeUtils.unescapeJava((String)UNICODENUM_STARTUP);
    private static String UNICODENUM_EXISTING_USERVIEW = "\u270e";
    private static final String UNICODECH_EXISTING_USERVIEW = String.valueOf(StringEscapeUtils.unescapeJava((String)UNICODENUM_EXISTING_USERVIEW)) + " ";
    private int curStartupViewIdx = -1;
    private boolean isWizardUserViewMode;
    private FocusListener listFocusListener = new FocusListener(){

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (UserViewPage.this.list.getSelectionIndex() > -1) {
                UserViewPage.this.setEnabledListControlButtons(true);
            } else {
                UserViewPage.this.setEnabledListControlButtons(false);
            }
        }
    };
    private SelectionListener listSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (UserViewPage.this.list.getSelectionIndex() > -1) {
                String[] stringArray = UserViewPage.this.list.getSelection();
                UserViewPage.this.btnDelete.setEnabled(true);
                if (stringArray.length == 1) {
                    UserViewPage.this.btnStartUp.setEnabled(true);
                } else {
                    UserViewPage.this.btnStartUp.setEnabled(false);
                }
            }
        }
    };
    private SelectionListener btnAddListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = UserViewPage.this.inputText.getText().trim();
            UserViewPage.this.addUserViewListItem(string);
            super.widgetSelected(selectionEvent);
            UserViewPage.this.setPageComplete(true);
        }
    };
    private SelectionListener btnDeleteListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = UserViewPage.this.list.getSelectionIndex();
            if (n > -1) {
                String string;
                String[] stringArray = UserViewPage.this.list.getSelection();
                boolean bl = true;
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    string = stringArray2[n3];
                    if (string.startsWith(UNICODECH_EXISTING_USERVIEW)) {
                        bl = DialogUtil.openQuestionDialog((String)Messages.PAGE_NAVI_USER_VIEW, (String)Messages.PAGE_USERVIEW_MSG_DELETE_CONFIRM) == 64;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    if (UserViewPage.this.list.isSelected(UserViewPage.this.curStartupViewIdx)) {
                        UserViewPage.this.curStartupViewIdx = -1;
                    }
                    UserViewPage.this.setPageComplete(true);
                    stringArray2 = stringArray;
                    n2 = stringArray.length;
                    n3 = 0;
                    while (n3 < n2) {
                        string = stringArray2[n3];
                        UserViewPage.this.list.remove(string);
                        string = string.replace(UNICODECH_EXISTING_USERVIEW, "").trim();
                        string = string.replace(UNICODECH_STARTUPVIEW, "").trim();
                        UserViewPage.this.currentUserViews.remove(string);
                        if (UserViewPage.this.isWizardUserViewMode && UserViewPage.this.prevUserViews.remove(string)) {
                            UserViewPage.this.deletedUserViews.add(string);
                        }
                        ++n3;
                    }
                    if (UserViewPage.this.list.getItemCount() < 1) {
                        UserViewPage.this.setEnabledListControlButtons(false);
                    }
                    UserViewPage.this.refreshStartupViewIdx();
                }
            }
            super.widgetSelected(selectionEvent);
        }
    };
    private SelectionListener btnStartUpListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = UserViewPage.this.list.getSelectionIndex();
            if (n > -1) {
                UserViewPage.this.setPageComplete(true);
                if (UserViewPage.this.isWizardUserViewMode) {
                    UserViewPage.this.setPageComplete(true);
                }
                String string = UserViewPage.this.list.getItem(n);
                if (n == UserViewPage.this.curStartupViewIdx) {
                    UserViewPage.this.list.setItem(n, StringUtil.removeEndsWith(string, UNICODECH_STARTUPVIEW).trim());
                    UserViewPage.this.curStartupViewIdx = -1;
                } else {
                    if (UserViewPage.this.curStartupViewIdx > -1) {
                        UserViewPage.this.list.setItem(UserViewPage.this.curStartupViewIdx, StringUtil.removeEndsWith(UserViewPage.this.list.getItem(UserViewPage.this.curStartupViewIdx), UNICODECH_STARTUPVIEW).trim());
                    }
                    UserViewPage.this.list.setItem(n, String.valueOf(string) + UNICODECH_STARTUPVIEW);
                    UserViewPage.this.curStartupViewIdx = n;
                }
                UserViewPage.this.list.setSelection(n);
            }
            super.widgetSelected(selectionEvent);
        }
    };
    private ModifyListener inputTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            String string = UserViewPage.this.inputText.getText().trim();
            if (UserViewPage.this.validateInputText(string)) {
                UIUtil.hideTooltipText();
                UserViewPage.this.btnAdd.setEnabled(true);
            } else {
                UserViewPage.this.btnAdd.setEnabled(false);
            }
            boolean bl = true;
            if (UserViewPage.this.isWizardUserViewMode) {
                bl = !UserViewPage.this.currentUserViews.equals(UserViewPage.this.prevUserViews) || UserViewPage.this.deletedUserViews.size() > 0;
            }
            UserViewPage.this.setPageComplete(!UserViewPage.this.btnAdd.isEnabled() && bl);
        }
    };
    private KeyAdapter inputTextKeyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 13: {
                    String string = UserViewPage.this.inputText.getText().trim();
                    if (!UserViewPage.this.validateInputText(string)) break;
                    UserViewPage.this.btnAdd.setFocus();
                    UserViewPage.this.addUserViewListItem(string);
                }
            }
        }
    };

    public UserViewPage(String string) {
        super(string);
        this.setTitle(Messages.PAGE_NAVI_USER_VIEW);
        this.setDescription(Messages.PAGE_USERVIEW_DESC);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.isWizardUserViewMode = ((ProjectMigratorWizard)this.getWizard()).getWizardMode().equals("MANAGEMENT_USER_VIEW");
        this.createUserViewComposite(composite2);
        this.setControl((Control)composite2);
        this.setPageComplete(!this.isWizardUserViewMode);
        if (this.isWizardUserViewMode) {
            this.preloadUserViews();
        }
    }

    private void preloadUserViews() {
        try {
            IFile iFile = FileUtil.getFile(((ProjectMigratorWizard)this.getWizard()).getProject(), CodeWriterConstants.SRC_PATH, "app_main.c");
            FuncCallParamGetVisitor funcCallParamGetVisitor = new FuncCallParamGetVisitor(null, "uib_views_get_instance()->add_user_views", 0);
            ASTManager aSTManager = new ASTManager();
            aSTManager.visit(iFile, 6, funcCallParamGetVisitor);
            this.currentUserViews = (ArrayList)funcCallParamGetVisitor.getResults();
            if (this.currentUserViews.size() > 0) {
                this.prevUserViews = (ArrayList)this.currentUserViews.clone();
                funcCallParamGetVisitor = new FuncCallParamGetVisitor(null, "uib_views_get_instance()->set_startup_view_name", 0);
                aSTManager.visit(iFile, 6, funcCallParamGetVisitor);
                String string = "";
                ArrayList arrayList = (ArrayList)funcCallParamGetVisitor.getResults();
                if (arrayList.size() > 0 && !StringUtil.isNullorEmpty(string = (String)arrayList.get(0))) {
                    this.curStartupViewIdx = this.currentUserViews.indexOf(string);
                }
                int n = 0;
                for (String string2 : this.currentUserViews) {
                    string2 = String.valueOf(UNICODECH_EXISTING_USERVIEW) + string2;
                    if (n == this.curStartupViewIdx) {
                        string2 = String.valueOf(string2) + UNICODECH_STARTUPVIEW;
                    }
                    this.list.add(string2);
                    ++n;
                }
                this.list.setSelection(0);
            }
        }
        catch (CodeWriterException codeWriterException) {
            this.logger.error(codeWriterException.getMessage());
        }
    }

    private void setEnabledListControlButtons(boolean bl) {
        this.btnDelete.setEnabled(bl);
        this.btnStartUp.setEnabled(bl);
    }

    private void addUserViewListItem(String string) {
        if (string.length() > 0) {
            this.currentUserViews.add(string);
            this.list.add(string);
            this.inputText.setText("");
            this.btnAdd.setEnabled(false);
            this.inputText.setFocus();
            this.setPageComplete(true);
        }
    }

    private boolean validateInputText(String string) {
        int n = string.length();
        if (n < 1) {
            UIUtil.hideTooltipText();
        } else if (n >= 31) {
            UIUtil.showTooltipText(this.inputText, Messages.PAGE_USERVIEW_MSG_NAME_LENGTH);
        } else if (this.currentUserViews.contains(string)) {
            UIUtil.showTooltipText(this.inputText, Messages.PAGE_USERVIEW_MSG_SAME_NAME);
        } else if (!UIUtil.validateRegExp(string) && n > 0) {
            UIUtil.showTooltipText(this.inputText, Messages.PAGE_USERVIEW_MSG_NAME_REGX);
        } else {
            return true;
        }
        return false;
    }

    private void createUserViewComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 25;
        gridLayout.verticalSpacing = 10;
        GridData gridData = new GridData(768);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 64);
        GridData gridData2 = new GridData(772);
        gridData2.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData2);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(Messages.PAGE_USERVIEW_MSG_STARTUP_DESC);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginHeight = 10;
        gridLayout2.marginWidth = 8;
        gridLayout2.verticalSpacing = 7;
        Group group = new Group(composite2, 16);
        group.setBackground(TizenColors.getTizenLightGrey());
        group.setText(Messages.PAGE_USERVIEW_MSG_GROUPNAME);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)gridData);
        this.list = new List((Composite)group, 2562);
        gridData = new GridData(768);
        gridData.heightHint = 250;
        this.list.setLayoutData((Object)gridData);
        this.list.addSelectionListener(this.listSelectionListener);
        this.list.addFocusListener(this.listFocusListener);
        this.inputText = new Text((Composite)group, 2048);
        this.inputText.setTextLimit(31);
        gridData = new GridData(768);
        gridData.heightHint = 15;
        this.inputText.setLayoutData((Object)gridData);
        this.inputText.setMessage(Messages.PAGE_USERVIEW_MSG_INPUT);
        this.inputText.addModifyListener(this.inputTextModifyListener);
        this.inputText.addKeyListener((KeyListener)this.inputTextKeyListener);
        Composite composite3 = new Composite((Composite)group, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.marginHeight = 10;
        gridLayout3.marginWidth = 0;
        gridLayout3.verticalSpacing = 0;
        gridLayout3.marginRight = 0;
        gridLayout3.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout3);
        gridData = new GridData(132);
        composite3.setLayoutData((Object)gridData);
        gridData = UIUtil.createGridData(768, 1, 131072, 100);
        gridData.horizontalIndent = 5;
        this.btnAdd = UIUtil.createButtonWithGridLayout(composite3, Messages.PAGE_USERVIEW_MSG_BTN_ADD, gridData, 8, false, true);
        this.btnAdd.addSelectionListener(this.btnAddListener);
        this.btnDelete = UIUtil.createButtonWithGridLayout(composite3, Messages.PAGE_USERVIEW_MSG_BTN_DEL, gridData, 8, false, true);
        this.btnDelete.addSelectionListener(this.btnDeleteListener);
        this.btnStartUp = UIUtil.createButtonWithGridLayout(composite3, Messages.PAGE_USERVIEW_MSG_BTN_STARTUP, gridData, 8, false, true);
        this.btnStartUp.addSelectionListener(this.btnStartUpListener);
    }

    public ArrayList<String> getUserViews() {
        return this.currentUserViews;
    }

    public ArrayList<String> getDeletedUserViews() {
        return this.deletedUserViews;
    }

    private void refreshStartupViewIdx() {
        int n = this.list.getItemCount();
        this.curStartupViewIdx = -1;
        int n2 = 0;
        while (n2 < n) {
            if (this.list.getItem(n2).endsWith(UNICODENUM_STARTUP)) {
                this.curStartupViewIdx = n2;
            }
            ++n2;
        }
    }

    public String getStartupViewName() {
        return this.curStartupViewIdx < 0 ? null : this.currentUserViews.get(this.curStartupViewIdx);
    }
}

