/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.tizen.efluibuilder.projectmigrator.ProjectMigratorUtil;
import org.tizen.efluibuilder.projectmigrator.ui.dialog.ProjectMigratorWizardDialog;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.ProjectMigratorWizard;

public class ConvertHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IProject iProject = this.extractProject(executionEvent);
        if (iProject == null) {
            return null;
        }
        Shell shell = Display.getDefault().getActiveShell();
        ProjectMigratorWizard projectMigratorWizard = new ProjectMigratorWizard();
        ProjectMigratorWizardDialog projectMigratorWizardDialog = new ProjectMigratorWizardDialog(shell, (IWizard)projectMigratorWizard);
        projectMigratorWizard.setModel(ProjectMigratorUtil.getPlatformProfile(iProject), iProject);
        projectMigratorWizardDialog.open();
        projectMigratorWizard.dispose();
        return null;
    }

    private IProject extractProject(ExecutionEvent executionEvent) {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        ISelection iSelection = iWorkbenchPage.getSelection();
        if (iSelection instanceof ITreeSelection) {
            TreeSelection treeSelection = (TreeSelection)iSelection;
            TreePath[] treePathArray = treeSelection.getPaths();
            TreePath treePath = treePathArray[0];
            Object object = treePath.getFirstSegment();
            IProject iProject = (IProject)((IAdaptable)object).getAdapter(IProject.class);
            return iProject;
        }
        return null;
    }
}

