/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ViewCodeGenerator {
    private static Logger logger = LoggerFactory.getLogger(ViewCodeGenerator.class);
    private static final String UI_VIEW_HEADER = "res/uib_view_header.xsl";
    private static final String UI_VIEW_SOURCE = "res/uib_view_source.xsl";
    private static final String UI_CONNECTION_SOURCE = "res/uib_connection_source.xsl";
    private File xslDirectory = null;
    private File targetDirectory;
    private String viewId;
    private String isRMSupportVersion;
    private String profile;

    public ViewCodeGenerator(File file, String string, String string2) {
        this.targetDirectory = file;
        this.isRMSupportVersion = string;
        this.profile = string2;
    }

    private String findViewName(Node node) {
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node2 = namedNodeMap.item(n);
            if (node2.getNodeName().equals("id")) {
                string = node2.getNodeValue();
            }
            ++n;
        }
        return string;
    }

    public void generate(Document document, Node node) throws TransformerException, IOException {
        String string = this.findViewName(node);
        this.generateViewHeader(document, this.getDestinationWriterForHeader(node), string);
        this.generateViewCode(document, this.getDestinationWriterForCode(node), string);
        this.generateConnectionCode(document, node, this.getDestinationWriterForConnection(node), string);
    }

    public void generateViewHeader(Node node, Writer writer, String string) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEW_HEADER);
        if (this.xslDirectory == null) {
            StreamSource streamSource = new StreamSource(inputStream);
            this.generateCode(node, writer, streamSource, string);
        } else {
            this.generateCode(node, writer, this.getXslFileForViewHeader(), string);
        }
        inputStream.close();
    }

    public void generateViewCode(Node node, Writer writer, String string) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEW_SOURCE);
        if (this.xslDirectory == null) {
            StreamSource streamSource = new StreamSource(inputStream);
            this.generateCode(node, writer, streamSource, string);
        } else {
            this.generateCode(node, writer, this.getXslFileForViewSource(), string);
        }
        inputStream.close();
    }

    public void generateConnectionCode(Document document, Node node, Writer writer, String string) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_CONNECTION_SOURCE);
        if (this.xslDirectory == null) {
            StreamSource streamSource = new StreamSource(inputStream);
            this.generateCode((Node)document, writer, streamSource, string);
        } else {
            this.generateCode((Node)document, writer, this.getXslFileForConnectionSource(), string);
        }
        inputStream.close();
    }

    private InputStream openStream(String string) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.tizen.efluibuilder.codegenerator");
        if (bundle == null) {
            logger.error("Invalid bundle");
            return null;
        }
        URL uRL = bundle.getResource(string);
        if (uRL == null) {
            logger.error("Invalid resource");
            return null;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream == null) {
            logger.error("Invalid stream");
            return null;
        }
        return inputStream;
    }

    private void generateCode(Node node, Writer writer, File file, String string) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource streamSource = new StreamSource(file);
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setParameter("current_view_name", string);
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
        writer.close();
    }

    private void generateCode(Node node, Writer writer, StreamSource streamSource, String string) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String string, String string2) throws TransformerException {
                String string3 = "res/" + string;
                try {
                    InputStream inputStream = ViewCodeGenerator.this.openStream(string3);
                    return new StreamSource(inputStream);
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage());
                    return null;
                }
            }
        });
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setParameter("current_view_name", string);
        if (this.isRMSupportVersion != null) {
            transformer.setParameter("is_version_rm_support", this.isRMSupportVersion);
        }
        if (this.profile != null) {
            transformer.setParameter("profile", this.profile);
        }
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
        writer.close();
    }

    private File getXslFileForViewSource() {
        File file = new File(this.xslDirectory, "uib_view_source.xsl");
        return file;
    }

    private File getXslFileForViewHeader() {
        File file = new File(this.xslDirectory, "uib_view_header.xsl");
        return file;
    }

    private Writer getDestinationWriterForCode(Node node) throws IOException {
        File file = new File(this.targetDirectory, "src/managed/src/view/" + this.getSourceFileName(node));
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForHeader(Node node) throws IOException {
        File file = new File(this.targetDirectory, "src/managed/inc/" + this.getHeaderFileName(node));
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    public String getViewId(Node node) {
        Node node2;
        if (this.viewId == null && (node2 = node.getAttributes().getNamedItem("id")) != null) {
            this.viewId = node2.getTextContent();
        }
        return this.viewId;
    }

    public String getSourceFileName(Node node) {
        return "uib_" + this.getViewId(node) + "_view.c";
    }

    public String getHeaderFileName(Node node) {
        return "uib_" + this.getViewId(node) + "_view.h";
    }

    private File getXslFileForConnectionSource() {
        File file = new File(this.xslDirectory, "uib_connection_source.xsl");
        return file;
    }

    private Writer getDestinationWriterForConnection(Node node) throws IOException {
        File file = new File(this.targetDirectory, "src/managed/src/connection/" + this.getConnectionFileName(node));
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    public String getConnectionFileName(Node node) {
        return "uib_" + this.getViewId(node) + "_connection.c";
    }
}

