<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="flipselector">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_flipselector_add(vc->',$parent,');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />

		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
		</xsl:apply-templates>

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="disable">
			<xsl:with-param name="disable" select="@disable" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />

	</xsl:template>
</xsl:stylesheet>
