/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.efluibuilder.projectmigrator.util.StringUtil;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final int MAX_SEQUENCE_NUM = 2147482647;

    public static void createFolder(IProject iProject, String string) throws CoreException {
        IFolder iFolder = iProject.getFolder(string);
        if (!iFolder.exists()) {
            iFolder.create(0, true, null);
        }
    }

    public static IFile getFile(IProject iProject, String string, String string2) {
        IFolder iFolder = iProject.getFolder(string);
        IFile iFile = iFolder.getFile(string2);
        return iFile;
    }

    public static IFile getFile(IProject iProject, String string) {
        IFile iFile = iProject.getFile(string);
        return iFile;
    }

    public static void selectProjectInProjectExplorer(IProject iProject) {
        try {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (iWorkbenchWindowArray == null) {
                return;
            }
            IWorkbenchWindow[] iWorkbenchWindowArray2 = iWorkbenchWindowArray;
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray2[n2];
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage != null) {
                    IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    iViewPart.setFocus();
                    if (iViewPart instanceof ProjectExplorer) {
                        ISelectionProvider iSelectionProvider = iViewPart.getSite().getSelectionProvider();
                        iSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)iProject));
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    public static IProject cloneProject(String string, String string2) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        IProjectDescription iProjectDescription = iProject.getDescription();
        IProjectDescription iProjectDescription2 = iWorkspaceRoot.getWorkspace().newProjectDescription(string2);
        iProject.copy(iProjectDescription2, true, (IProgressMonitor)new NullProgressMonitor());
        IProject iProject2 = iWorkspaceRoot.getProject(string2);
        iProjectDescription2.setNatureIds(iProjectDescription.getNatureIds());
        iProjectDescription2.setReferencedProjects(iProjectDescription.getReferencedProjects());
        iProjectDescription2.setDynamicReferences(iProjectDescription.getDynamicReferences());
        iProjectDescription2.setBuildSpec(iProjectDescription.getBuildSpec());
        iProjectDescription2.setReferencedProjects(iProjectDescription.getReferencedProjects());
        iProject2.setDescription(iProjectDescription2, null);
        return iProject2;
    }

    public static String findCloneProjectNameforConvert(String string) {
        String string2 = "withUIB";
        String string3 = "";
        String string4 = "";
        string4 = StringUtil.removeEndsWithDigit(string);
        if (string4.endsWith(string2)) {
            string = string4;
        }
        string = StringUtil.removeEndsWith(string, string2);
        ArrayList<String> arrayList = FileUtil.getProjectNamesInWorkspace(string);
        boolean bl = false;
        int n = 0;
        while (n < 2147482647) {
            bl = true;
            String string5 = n < 1 ? string2 : String.valueOf(string2) + n;
            for (String string6 : arrayList) {
                string3 = String.valueOf(string) + string5;
                if (!string6.endsWith(string5)) continue;
                bl = false;
                break;
            }
            if (bl) {
                logger.debug(">Clone project name is {%s} for convert", (Object)string3);
                return string3;
            }
            ++n;
        }
        return string3;
    }

    public static ArrayList<String> getProjectNamesInWorkspace(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        ArrayList<String> arrayList = new ArrayList<String>();
        IProject[] iProjectArray2 = iProjectArray;
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            String string2 = iProject.getName();
            if (string != null && string2.startsWith(string)) {
                arrayList.add(string2);
            }
            ++n2;
        }
        return arrayList;
    }

    public static void renameProject(IProject iProject, String string) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setName(string);
        iProject.move(iProjectDescription, 33, null);
    }

    public static void deleteProject(IProject iProject) throws CoreException {
        boolean bl = true;
        boolean bl2 = true;
        if (iProject != null && iProject.exists()) {
            iProject.delete(bl, bl2, null);
        }
    }

    public static void refreshProject(IProject iProject) throws CoreException {
        iProject.refreshLocal(2, null);
    }
}

