/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.efluibuilder.project.core.NUIBProjectUtil;
import org.tizen.efluibuilder.projectmigrator.ProjectConvertParam;
import org.tizen.efluibuilder.projectmigrator.ProjectMigratorException;
import org.tizen.efluibuilder.projectmigrator.ui.dialog.ProjectMigratorWizardDialog;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;
import org.tizen.efluibuilder.projectmigrator.ui.progress.ProgressMonitorDialogEx;
import org.tizen.efluibuilder.projectmigrator.ui.progress.ProjectMigratorRunnableWithProgress;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.AppEntryPage;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.BaseWizardPage;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.MainPage;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.ShapeTypePage;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.UserViewPage;
import org.tizen.efluibuilder.projectmigrator.util.FileUtil;
import org.tizen.efluibuilder.projectmigrator.util.StringUtil;

public class ProjectMigratorWizard
extends Wizard
implements IPageChangedListener {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IProject project;
    private ProjectMigratorWizardDialog wizardDialog;
    private static final String CUSTOM_PERSPECTIVE_NAME = "org.tizen.efluibuilder.ui.perspective.NUIBPerspective";
    private String wizardMode;
    private String[] pageNavigations;
    private static final String[] pageNavigationsMobile = new String[]{Messages.PAGE_NAVI_APP_ENTRY, Messages.PAGE_NAVI_USER_VIEW};
    private static final String[] pageNavigationsWearable = new String[]{Messages.PAGE_NAVI_SHAPE_TYPE, Messages.PAGE_NAVI_APP_ENTRY, Messages.PAGE_NAVI_USER_VIEW};

    public void setModel(String string, IProject iProject) {
        this.wizardMode = string;
        this.project = iProject;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getWizardMode() {
        return this.wizardMode;
    }

    private void setNavigationIndexWizardPages() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 0;
        IWizardPage[] iWizardPageArray2 = iWizardPageArray;
        int n2 = iWizardPageArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IWizardPage iWizardPage = iWizardPageArray2[n3];
            if (iWizardPage instanceof BaseWizardPage && this.getStartingPage() != iWizardPage) {
                ((BaseWizardPage)iWizardPage).setNavigationIndex(n++);
            }
            ++n3;
        }
    }

    private void createMobilePages() {
        this.pageNavigations = pageNavigationsMobile;
        this.setWindowTitle(Messages.WIZARD_TITLE_CONVERTER);
        this.addPage((IWizardPage)new MainPage(MainPage.class.getName()));
        this.addPage((IWizardPage)new AppEntryPage(AppEntryPage.class.getName()));
        this.addPage((IWizardPage)new UserViewPage(UserViewPage.class.getName()));
        this.setNavigationIndexWizardPages();
    }

    private void createWearablePages() {
        this.setWindowTitle(Messages.WIZARD_TITLE_CONVERTER);
        this.pageNavigations = pageNavigationsWearable;
        this.addPage((IWizardPage)new MainPage(MainPage.class.getName()));
        this.addPage((IWizardPage)new ShapeTypePage(ShapeTypePage.class.getName()));
        this.addPage((IWizardPage)new AppEntryPage(AppEntryPage.class.getName()));
        this.addPage((IWizardPage)new UserViewPage(UserViewPage.class.getName()));
        this.setNavigationIndexWizardPages();
    }

    private void createUserViewModePages() {
        this.setWindowTitle(Messages.WIZARD_TITLE_USER_VIEW);
        this.pageNavigations = null;
        this.addPage((IWizardPage)new UserViewPage(UserViewPage.class.getName()));
    }

    public void addPages() {
        if (this.wizardMode == null) {
            return;
        }
        if (this.wizardMode.equals("mobile")) {
            this.createMobilePages();
        } else if (this.wizardMode.equals("wearable")) {
            this.createWearablePages();
        } else if (this.wizardMode.equals("MANAGEMENT_USER_VIEW")) {
            this.createUserViewModePages();
        }
        this.wizardDialog = (ProjectMigratorWizardDialog)this.getContainer();
        this.wizardDialog.addPageChangedListener(this);
        this.wizardDialog.setNavigationString(this.pageNavigations);
        this.getShell().setMinimumSize(680, 550);
        this.getShell().setLocation(0x1000000, 0x1000000);
    }

    public boolean canFinish() {
        IWizardPage iWizardPage = this.getContainer().getCurrentPage();
        IWizardPage iWizardPage2 = this.getPages()[this.getPageCount() - 1];
        if (iWizardPage != null && iWizardPage.equals(iWizardPage2)) {
            return iWizardPage.isPageComplete();
        }
        return false;
    }

    public boolean performCancel() {
        String string = this.wizardMode.equals("MANAGEMENT_USER_VIEW") ? Messages.WIZARD_CANCEL : Messages.WIZARD_CANCEL_CONVERSION;
        int n = DialogUtil.openQuestionDialog((String)this.getWindowTitle(), (String)string);
        return n == 64;
    }

    public boolean performFinish() {
        try {
            Shell shell = this.getShell();
            IWizardPage[] iWizardPageArray = this.getPages();
            ProjectConvertParam projectConvertParam = new ProjectConvertParam();
            projectConvertParam.setCloneProjectName(FileUtil.findCloneProjectNameforConvert(this.project.getName()));
            IWizardPage[] iWizardPageArray2 = iWizardPageArray;
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                BaseWizardPage baseWizardPage;
                IWizardPage iWizardPage = iWizardPageArray2[n2];
                if (iWizardPage.getName().equals(AppEntryPage.class.getName())) {
                    baseWizardPage = (AppEntryPage)iWizardPage;
                    projectConvertParam.setUIBAppEntry(((AppEntryPage)baseWizardPage).isSelectedAppEntryUIB());
                    projectConvertParam.setAppEntryRelativeFilePath(((AppEntryPage)baseWizardPage).getAppEntryRelativeFilePath());
                } else if (iWizardPage.getName().equals(ShapeTypePage.class.getName())) {
                    baseWizardPage = (ShapeTypePage)iWizardPage;
                    projectConvertParam.setShapeCircle(((ShapeTypePage)baseWizardPage).isSelectedShapeTypeCircle());
                } else if (iWizardPage.getName().equals(UserViewPage.class.getName())) {
                    baseWizardPage = (UserViewPage)iWizardPage;
                    projectConvertParam.setUserViews(((UserViewPage)baseWizardPage).getUserViews());
                    projectConvertParam.setDeletedUserViews(((UserViewPage)baseWizardPage).getDeletedUserViews());
                    projectConvertParam.setStartupViewName(((UserViewPage)baseWizardPage).getStartupViewName());
                }
                ++n2;
            }
            this.createProgressMonitorDialog(shell, this.project, projectConvertParam);
        }
        catch (ProjectMigratorException projectMigratorException) {
            this.logger.error(projectMigratorException.getMessage());
            this.logger.error(StringUtil.getStackTraceToString(projectMigratorException));
            DialogUtil.openErrorDialog((String)Messages.WIZARD_TITLE_CONVERTER, (String)projectMigratorException.getMessage());
        }
        return true;
    }

    private void createProgressMonitorDialog(Shell shell, IProject iProject, ProjectConvertParam projectConvertParam) throws ProjectMigratorException {
        ProgressMonitorDialogEx progressMonitorDialogEx = new ProgressMonitorDialogEx(shell, Messages.WIZARD_TITLE_CONVERTER);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key_model_param", projectConvertParam);
        hashMap.put("key_model_wizard_mode", this.wizardMode);
        ProjectMigratorRunnableWithProgress projectMigratorRunnableWithProgress = new ProjectMigratorRunnableWithProgress(iProject, hashMap);
        try {
            progressMonitorDialogEx.run(true, !"MANAGEMENT_USER_VIEW".equals(this.wizardMode), projectMigratorRunnableWithProgress);
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject iProject2 = iWorkspaceRoot.getProject(projectConvertParam.getCloneProjectName());
            if (iProject2 != null && iProject2.exists()) {
                this.doPostJob(iProject2);
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            this.logger.error(exception.getMessage());
            throw new ProjectMigratorException(Messages.CORE_EXCEPTION_MSG_RUN_PROGRESS_DIALOG);
        }
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public void pageChanged(PageChangedEvent pageChangedEvent) {
        BaseWizardPage baseWizardPage = (BaseWizardPage)((Object)pageChangedEvent.getSelectedPage());
        if (this.pageNavigations == null || baseWizardPage instanceof MainPage) {
            this.wizardDialog.setVisiblePageNavigator(false);
        } else {
            this.wizardDialog.setVisiblePageNavigator(true);
            this.wizardDialog.setNavigatorCurrentPage(baseWizardPage.getNavigationIndex());
            this.wizardDialog.redrawNavigator();
        }
        this.wizardDialog.updateTitleBar();
    }

    private void doPostJob(IProject iProject) {
        try {
            FileUtil.selectProjectInProjectExplorer(iProject);
            SWTUtil.showPerspective((String)CUSTOM_PERSPECTIVE_NAME);
            NUIBProjectUtil.addNature((IProject)iProject, (IProgressMonitor)new NullProgressMonitor());
            NUIBProjectUtil.open((IProject)iProject);
        }
        catch (ProcessFailureException | WorkbenchException throwable) {
            this.logger.error(throwable.getMessage(), throwable);
        }
    }
}

