/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.utility;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IDEUtil {
    private static Logger logger = LoggerFactory.getLogger(IDEUtil.class);

    public static void showIndicator(final long l) {
        logger.info("Start");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Start");
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        logger.info("End");
                    }
                });
            }
        });
        logger.info("End");
    }

    private static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        return IDEUtil.getWorkbench().getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = IDEUtil.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            throw new NullPointerException("IWorkbenchWindow window is null");
        }
        return iWorkbenchWindow.getActivePage();
    }

    public static void open(final IFile iFile) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDEUtil.openEditor(iFile);
                }
                catch (PartInitException partInitException) {
                    partInitException.printStackTrace();
                    return;
                }
            }
        });
    }

    public static void openEditor(IFile iFile) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = IDEUtil.getActivePage();
        if (iWorkbenchPage == null) {
            throw new NullPointerException("IWorkbenchPage page is null");
        }
        IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
    }

    public static void selectProjectExplorer(IFile iFile) {
        IWorkbenchPage iWorkbenchPage = IDEUtil.getActivePage();
        if (iWorkbenchPage == null) {
            throw new NullPointerException("IWorkbenchPage page is null");
        }
        IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (iViewPart == null) {
            return;
        }
        if (iViewPart instanceof ISetSelectionTarget) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)iFile);
            ((ISetSelectionTarget)iViewPart).selectReveal((ISelection)structuredSelection);
        }
    }

    public static Shell getRealCurrentActiveShell() {
        Shell shell = null;
        Display display = Display.getDefault();
        Shell[] shellArray = display.getShells();
        shell = shellArray[shellArray.length - 1];
        return shell;
    }

    public static int showErrorDialogWithStacktrace(String string, Shell shell, String string2, String string3, Throwable throwable) {
        MultiStatus multiStatus = IDEUtil.getMultiStatusForStackTrace(string, throwable);
        return ErrorDialog.openError((Shell)shell, (String)string2, (String)string3, (IStatus)multiStatus);
    }

    public static MultiStatus getMultiStatusForStackTrace(String string, Throwable throwable) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            arrayList.add(new Status(4, string, stackTraceElement.toString()));
            ++n2;
        }
        return new MultiStatus(string, 4, arrayList.toArray(new IStatus[0]), throwable.toString(), throwable);
    }
}

