<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="*" mode="box.pack">
		<xsl:param name="parent" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:if test="@id != ''">
			<xsl:value-of select="concat($indentation,'elm_box_pack_end(vc->',$parent,', vc->',@id,');')" />
			<xsl:value-of select="$newline" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="box">
		<xsl:param name="parent" />
		<xsl:param name="fromView" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="profile" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$fromView = 'true'">
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_box_add(parent);', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->root_container = vc->', @id, ';')" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string-length($fromView) = 0">
					<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
					<xsl:value-of select="concat($indentation1,'vc->', @id, ' = elm_box_add(vc->', $parent, ');', $newline)" />
					<xsl:value-of select="concat($indentation,'}', $newline)" />
				</xsl:if>
				<xsl:value-of select="$indentation" />
				<xsl:value-of select="concat('if(vc->', @id, ') {')" />
				<xsl:value-of select="$newline" />
				<xsl:value-of select="$indentation1" />
				<!-- Check efl api for component transparency -->
				<xsl:choose>
					<xsl:when test="@transparency='true'">
						<xsl:value-of select="concat('elm_win_alpha_set(vc->', @id, ', EINA_TRUE);')" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('elm_win_alpha_set(vc->', @id, ', EINA_FALSE);')" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$newline" />
				<xsl:value-of select="$indentation1" />

				<xsl:choose>
					<xsl:when test="@homogeneous='true'">
						<xsl:value-of select="concat('elm_box_homogeneous_set(vc->', @id, ', EINA_TRUE);')" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('elm_box_homogeneous_set(vc->', @id, ', EINA_FALSE);')" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$newline" />
				<xsl:value-of select="$indentation1" />

				<xsl:choose>
					<xsl:when test="@direction='horizontal'">
						<xsl:value-of select="concat('elm_box_horizontal_set(vc->', @id, ', EINA_TRUE);')" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('elm_box_horizontal_set(vc->', @id, ', EINA_FALSE);')" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$newline" />
				<xsl:value-of select="concat($indentation1, 'elm_box_padding_set(vc->', @id, ',', @padding_h, ',', @padding_v,');', $newline)" />
				<xsl:call-template name="size_hint_align_set">
					<xsl:with-param name="align_h" select="@align_h" />
					<xsl:with-param name="align_v" select="@align_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>
				<xsl:value-of select="$newline" />

				<xsl:call-template name="size_hint_weight_set">
					<xsl:with-param name="weight_h" select="@weight_h" />
					<xsl:with-param name="weight_v" select="@weight_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>
				<xsl:value-of select="$newline" />

				<xsl:apply-templates select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
					<xsl:with-param name="profile" select="$profile" />
				</xsl:apply-templates>

				<xsl:apply-templates mode="box.pack" select="*">
					<xsl:with-param name="parent" select="@id" />
				</xsl:apply-templates>

				<xsl:if test="@disable = 'true'">
					<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:if>
				<xsl:apply-templates mode="visible" select="current()">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
				</xsl:apply-templates>
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
