/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.renderer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.efluibuilder.internal.renderer.Renderer;
import org.tizen.efluibuilder.internal.renderer.command.ICommand;
import org.tizen.efluibuilder.renderer.IArguments;
import org.tizen.efluibuilder.renderer.IRenderer;
import org.tizen.efluibuilder.renderer.IRendererListener;
import org.tizen.efluibuilder.renderer.event.RenderEvent;
import org.tizen.efluibuilder.renderer.event.ReplyEvent;

public abstract class AbstractRenderer
extends EventManager
implements IRenderer {
    protected static Logger logger = LoggerFactory.getLogger(Renderer.class);
    private static final int TIMEOUT_REQUEST = 1000;
    private final Synchronizer lock = new Synchronizer();
    private int id = 0;
    private String name = null;
    private String version = null;
    private String profile = null;
    private String projectPath = null;
    private int width = 0;
    private int height = 0;
    private Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private Map<String, String> ids = new HashMap<String, String>();

    public AbstractRenderer() {
        this.createCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IArguments lock() {
        Synchronizer synchronizer = this.lock;
        synchronized (synchronizer) {
            try {
                this.lock.setMessage(null);
                this.lock.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                logger.error(interruptedException.getMessage());
            }
        }
        return this.lock.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(IArguments iArguments) {
        Assert.notNull((Object)iArguments);
        Synchronizer synchronizer = this.lock;
        synchronized (synchronizer) {
            this.lock.setMessage(iArguments);
            this.lock.notify();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setProfile(String string) {
        this.profile = string;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProject(String string) {
        this.projectPath = string;
    }

    public String getProject() {
        return this.projectPath;
    }

    protected void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public Point getSize() {
        return new Point(this.width, this.height);
    }

    @Override
    public void addRendererListener(IRendererListener iRendererListener) {
        this.addListenerObject(iRendererListener);
    }

    @Override
    public void removeRendererListener(IRendererListener iRendererListener) {
        this.removeListenerObject(iRendererListener);
    }

    protected synchronized void request(IArguments iArguments) {
        ICommand iCommand = this.findCommand(iArguments.getId(), FindType.COMMAND_ID);
        if (iCommand == null) {
            throw new NullPointerException("Can not found command");
        }
        if (iCommand.isSynchronous()) {
            this.requestSync(iArguments);
        } else {
            iCommand.request(iArguments);
        }
    }

    private synchronized IArguments requestSync(IArguments iArguments) {
        ICommand iCommand = this.findCommand(iArguments.getId(), FindType.COMMAND_ID);
        if (iCommand == null) {
            throw new NullPointerException("Can not found command");
        }
        Assert.isTrue((boolean)iCommand.isSynchronous(), (String)("Illegal sync command : " + iCommand.getId()));
        iCommand.request(iArguments);
        IArguments iArguments2 = this.lock();
        if (iArguments2 == null) {
            logger.error("request timeout");
        } else {
            String string = iArguments2.getId();
            if (string.equals("exception")) {
                logger.error("Exception");
                return null;
            }
        }
        return iArguments2;
    }

    public void setId(int n) {
        this.id = n;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    protected void registerCommand(ICommand iCommand) {
        this.commands.put(iCommand.getId(), iCommand);
        this.ids.put(iCommand.getEventName(), iCommand.getId());
    }

    protected ICommand findCommand(String string, FindType findType) {
        if (findType.equals((Object)FindType.COMMAND_ID)) {
            return this.commands.get(string);
        }
        if (findType.equals((Object)FindType.EVENT_NAME)) {
            String string2 = this.ids.get(string);
            return this.commands.get(string2);
        }
        return null;
    }

    protected void handleReceiveEvent(ReplyEvent replyEvent) {
        ICommand iCommand = this.findCommand(replyEvent.name, FindType.EVENT_NAME);
        if (iCommand == null) {
            return;
        }
        IArguments iArguments = iCommand.reply(replyEvent);
        if (iArguments == null) {
            logger.error("message is null");
        }
        if (!iCommand.isSynchronous()) {
            this.handleReply(iArguments);
            return;
        }
        Assert.notNull((Object)iArguments);
        this.unlock(iArguments);
    }

    protected void fireReplyRender(final RenderEvent renderEvent) {
        Object[] objectArray;
        if (renderEvent == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (!this.isListenerAttached()) {
            return;
        }
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object object = objectArray2[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ((IRendererListener)object).replyRender(renderEvent);
                }
            });
            ++n2;
        }
    }

    protected void fireEvent(final IArguments iArguments) {
        Object[] objectArray;
        if (iArguments == null) {
            throw new NullPointerException("Cannot send a null message to listeners.");
        }
        if (!this.isListenerAttached()) {
            return;
        }
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object object = objectArray2[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ((IRendererListener)object).reply(iArguments);
                }
            });
            ++n2;
        }
    }

    public String toString() {
        return String.format("<Renderer  id : %d | name : %s>", this.getId(), this.getName());
    }

    protected abstract void createCommands();

    protected abstract boolean handleReply(IArguments var1);

    protected static enum FindType {
        COMMAND_ID,
        EVENT_NAME;

    }

    private static class Synchronizer {
        private IArguments args = null;

        private Synchronizer() {
        }

        public void setMessage(IArguments iArguments) {
            this.args = iArguments;
        }

        public IArguments getMessage() {
            return this.args;
        }
    }
}

