/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.ui.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.ui.wizards.project.template.widgets.PageNavigator;

public class WizardDialog
extends TitleAreaDialog
implements IWizardContainer2,
IPageChangeProvider {
    public static final String WIZ_IMG_ERROR = "dialog_title_error_image";
    private static final int WIZ_DLG_TITLE_PAGE_NAVI_HEIGHT = 34;
    private static final int WIZ_DLG_TITLE_DESC_HEIGHT = 64;
    private static final int WIZ_DLG_TITLE_HEIGHT = 98;
    public static final int WIZ_DLG_WIDTH = 850;
    public static final int WIZ_DLG_HEIGHT = 627;
    private IWizard wizard;
    private ArrayList<IWizard> createdWizards = new ArrayList();
    private ArrayList<IWizard> nestedWizards = new ArrayList();
    private IWizardPage currentPage = null;
    private long activeRunningOperations = 0L;
    private long timeWhenLastJobFinished = -1L;
    private boolean useCustomProgressMonitorPart = true;
    private String pageMessage;
    private int pageMessageType = 0;
    private String pageDescription;
    private ProgressMonitorPart progressMonitorPart;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private MessageDialog windowClosingDialog;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    private Button helpButton;
    private Label titleLabel;
    private Label descLabelTypePageNavi;
    private Label descLabelTypeMsg;
    private PageNavigator pageNavigator;
    private String[] navigatorString = null;
    private SelectionAdapter cancelListener;
    private boolean isMovingToPreviousPage = false;
    private Composite pageContainer;
    private PageContainerFillLayout pageContainerLayout = new PageContainerFillLayout(0, 0, 300, 225);
    private int pageWidth = -1;
    private int pageHeight = -1;
    private static final String FOCUS_CONTROL = "focusControl";
    private static final int RESTORE_ENTER_DELAY = 500;
    private boolean lockedUI = false;
    private ListenerList pageChangedListeners = new ListenerList();
    private ListenerList pageChangingListeners = new ListenerList();
    private StackLayout stl;
    private Composite pageNaviTitleComp;
    private Composite pageNaviUnTitleComp;
    private Composite contentPanel;

    public WizardDialog(Shell shell, IWizard iWizard) {
        super(shell);
        this.setShellStyle(0x10C70 | WizardDialog.getDefaultOrientation());
        this.setWizard(iWizard);
        this.cancelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardDialog.this.cancelPressed();
            }
        };
    }

    private Object aboutToStart(boolean bl) {
        Map<String, Object> map = null;
        if (this.getShell() != null) {
            Control control = this.getShell().getDisplay().getFocusControl();
            if (control != null && control.getShell() != this.getShell()) {
                control = null;
            }
            boolean bl2 = this.wizard.needsProgressMonitor();
            Display display = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)display, 1);
            this.setDisplayCursor(this.waitCursor);
            if (this.useCustomProgressMonitorPart) {
                this.cancelButton.removeSelectionListener((SelectionListener)this.cancelListener);
                this.arrowCursor = new Cursor((Device)display, 0);
                this.cancelButton.setCursor(this.arrowCursor);
            }
            map = this.saveUIState(this.useCustomProgressMonitorPart && bl2 && bl);
            if (control != null) {
                map.put(FOCUS_CONTROL, control);
            }
            if (bl2) {
                if (bl || this.useCustomProgressMonitorPart) {
                    this.progressMonitorPart.attachToCancelComponent((Control)this.cancelButton);
                }
                this.progressMonitorPart.setVisible(true);
            }
            if (this.timeWhenLastJobFinished == -1L) {
                this.timeWhenLastJobFinished = 0L;
                this.getShell().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent traverseEvent) {
                        if (traverseEvent.detail == 4 || traverseEvent.detail == 128 && traverseEvent.keyCode == 32) {
                            if (WizardDialog.this.timeWhenLastJobFinished != 0L && System.currentTimeMillis() - WizardDialog.this.timeWhenLastJobFinished < 500L) {
                                traverseEvent.doit = false;
                                return;
                            }
                            WizardDialog.this.timeWhenLastJobFinished = 0L;
                        }
                    }
                });
            }
        }
        return map;
    }

    protected void backPressed() {
        IWizardPage iWizardPage = this.currentPage.getPreviousPage();
        if (iWizardPage == null) {
            return;
        }
        this.isMovingToPreviousPage = true;
        this.showPage(iWizardPage);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                this.finishPressed();
            }
        }
    }

    private Point calculatePageSizeDelta(IWizardPage iWizardPage) {
        Control control = iWizardPage.getControl();
        if (control == null) {
            return new Point(0, 0);
        }
        Point point = control.computeSize(-1, -1, true);
        Rectangle rectangle = this.pageContainerLayout.getClientArea(this.pageContainer);
        Point point2 = new Point(rectangle.width, rectangle.height);
        return new Point(Math.max(0, point.x - point2.x), Math.max(0, point.y - point2.y));
    }

    protected void cancelPressed() {
        if (this.activeRunningOperations <= 0L) {
            this.setReturnCode(1);
            this.close();
        } else {
            this.cancelButton.setEnabled(false);
        }
    }

    public boolean close() {
        if (this.okToClose()) {
            return this.hardClose();
        }
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                if (WizardDialog.this.currentPage != null) {
                    WizardDialog.this.currentPage.performHelp();
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite composite) {
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        if (this.wizard.isHelpAvailable()) {
            this.helpButton = this.createButton(composite, 17, IDialogConstants.HELP_LABEL, false);
        }
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(composite);
        }
        this.finishButton = this.createButton(composite, 16, IDialogConstants.FINISH_LABEL, true);
        this.cancelButton = this.createCancelButton(composite);
        if (composite.getDisplay().getDismissalAlignment() == 131072) {
            this.finishButton.moveBelow(null);
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int n = this.convertHorizontalDLUsToPixels(61);
        n = Math.min(n, button.getDisplay().getBounds().width / 5);
        Point point = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(n, point.x);
        button.setLayoutData((Object)gridData);
    }

    private Button createCancelButton(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        button.setText(IDialogConstants.CANCEL_LABEL);
        this.setButtonLayoutData(button);
        button.setFont(composite.getFont());
        button.setData((Object)new Integer(1));
        button.addSelectionListener((SelectionListener)this.cancelListener);
        return button;
    }

    protected Button getButton(int n) {
        if (n == 1) {
            return this.cancelButton;
        }
        return super.getButton(n);
    }

    protected Control createContents(Composite composite) {
        this.wizard.addPages();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)composite2);
        FormLayout formLayout = new FormLayout();
        composite2.setLayout((Layout)formLayout);
        composite2.setBackground(this.getShell().getDisplay().getSystemColor(1));
        composite2.setBackgroundMode(2);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        this.createTitleArea(composite2);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.contentPanel, 0);
        formData.right = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        composite3.setLayoutData((Object)formData);
        composite3.setFont(JFaceResources.getDialogFont());
        composite3.setBackground(TizenColors.getTizenLightGrey());
        this.initializeDialogUnits((Control)composite3);
        this.dialogArea = this.createDialogArea(composite3);
        this.buttonBar = this.createButtonBar(composite3);
        this.buttonBar.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.createPageControls();
        this.showStartingPage();
        return composite2;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        this.pageContainer = this.createPageContainer(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.pageWidth;
        gridData.heightHint = this.pageHeight;
        this.pageContainer.setLayoutData((Object)gridData);
        this.pageContainer.setFont(composite.getFont());
        Canvas canvas = new Canvas(composite, 0);
        canvas.setBackground(TizenColors.getTizenSmokeGrey());
        GridData gridData2 = new GridData(768);
        gridData2.heightHint = 1;
        canvas.setLayoutData((Object)gridData2);
        WizardDialog.applyDialogFont((Control)this.progressMonitorPart);
        return composite2;
    }

    private Composite createTitlePageNaviArea(Composite composite) {
        this.pageNaviTitleComp = new Composite(composite, 1);
        this.pageNaviTitleComp.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.height = 34;
        this.pageNavigator = new PageNavigator(this.pageNaviTitleComp, this.navigatorString);
        this.pageNavigator.setTextFont(TizenFonts.getFont((int)0, (int)0));
        this.pageNavigator.setTextBoldFont(TizenFonts.getFont((int)0, (int)1));
        this.pageNavigator.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)this.pageNavigator);
        formData.height = 64;
        Composite composite2 = new Composite(this.pageNaviTitleComp, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)formData);
        this.descLabelTypePageNavi = new Label(composite2, 64);
        GridData gridData = new GridData(772);
        gridData.grabExcessVerticalSpace = true;
        this.descLabelTypePageNavi.setLayoutData((Object)gridData);
        this.descLabelTypePageNavi.setFont(JFaceResources.getDialogFont());
        return composite2;
    }

    private Composite createTitleMsgArea(Composite composite) {
        this.pageNaviUnTitleComp = new Composite(composite, 1);
        this.pageNaviUnTitleComp.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(this.pageNaviUnTitleComp, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData(772);
        gridLayout.marginWidth = 20;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.descLabelTypeMsg = new Label(composite2, 64);
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 850;
        this.descLabelTypeMsg.setLayoutData((Object)gridData);
        this.descLabelTypeMsg.setFont(JFaceResources.getDialogFont());
        return composite2;
    }

    private void createTitleArea(Composite composite) {
        this.stl = new StackLayout();
        this.contentPanel = new Composite(composite, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.height = 98;
        this.contentPanel.setLayout((Layout)this.stl);
        this.contentPanel.setLayoutData((Object)formData);
        if (this.navigatorString != null) {
            this.createTitlePageNaviArea(this.contentPanel);
        }
        this.createTitleMsgArea(this.contentPanel);
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout gridLayout) {
        this.useCustomProgressMonitorPart = false;
        return new ProgressMonitorPart(composite, (Layout)gridLayout, true){
            String currentTask;
            {
                this.currentTask = null;
            }

            public void setBlocked(IStatus iStatus) {
                super.setBlocked(iStatus);
                if (!WizardDialog.this.lockedUI) {
                    WizardDialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, iStatus, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!WizardDialog.this.lockedUI) {
                    WizardDialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String string, int n) {
                super.beginTask(string, n);
                this.currentTask = string;
            }

            public void setTaskName(String string) {
                super.setTaskName(string);
                this.currentTask = string;
            }

            public void subTask(String string) {
                super.subTask(string);
                if (this.currentTask == null) {
                    this.currentTask = string;
                }
            }
        };
    }

    private Composite createPageContainer(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.pageContainerLayout);
        return composite2;
    }

    private void createPageControls() {
        this.wizard.createPageControls(this.pageContainer);
        IWizardPage[] iWizardPageArray = this.wizard.getPages();
        int n = 0;
        while (n < iWizardPageArray.length) {
            IWizardPage iWizardPage = iWizardPageArray[n];
            if (iWizardPage.getControl() != null) {
                iWizardPage.getControl().setVisible(false);
            }
            ++n;
        }
    }

    private Composite createPreviousAndNextButtons(Composite composite) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(68);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.backButton = this.createButton(composite2, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(composite2, 15, IDialogConstants.NEXT_LABEL, false);
        final String string = IDialogConstants.BACK_LABEL.replace('<', ' ');
        this.backButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = string;
            }
        });
        final String string2 = IDialogConstants.NEXT_LABEL.replace('>', ' ');
        this.nextButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = string2;
            }
        });
        return composite2;
    }

    private MessageDialog createWizardClosingDialog() {
        MessageDialog messageDialog = new MessageDialog(this.getShell(), JFaceResources.getString((String)"WizardClosingDialog.title"), null, JFaceResources.getString((String)"WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return messageDialog;
    }

    protected void finishPressed() {
        if (this.wizard.performFinish()) {
            int n = 0;
            while (n < this.nestedWizards.size() - 1) {
                this.nestedWizards.get(n).performFinish();
                ++n;
            }
            this.setReturnCode(0);
            this.hardClose();
        }
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    protected IWizard getWizard() {
        return this.wizard;
    }

    private boolean hardClose() {
        int n = 0;
        while (n < this.createdWizards.size()) {
            IWizard iWizard = this.createdWizards.get(n);
            try {
                iWizard.dispose();
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.jface", 4, exception.getMessage(), (Throwable)exception);
                Policy.getLog().log((IStatus)status);
            }
            iWizard.setContainer(null);
            ++n;
        }
        this.setTitleImage(null);
        return super.close();
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected void nextPressed() {
        IWizardPage iWizardPage = this.currentPage.getNextPage();
        if (iWizardPage == null) {
            return;
        }
        this.showPage(iWizardPage);
    }

    private boolean doPageChanging(IWizardPage iWizardPage) {
        PageChangingEvent pageChangingEvent = new PageChangingEvent((Object)this, (Object)this.getCurrentPage(), (Object)iWizardPage);
        this.firePageChanging(pageChangingEvent);
        return pageChangingEvent.doit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            WizardDialog wizardDialog = this;
            synchronized (wizardDialog) {
                this.windowClosingDialog = this.createWizardClosingDialog();
            }
            this.windowClosingDialog.open();
            wizardDialog = this;
            synchronized (wizardDialog) {
                this.windowClosingDialog = null;
            }
            return false;
        }
        return this.wizard.performCancel();
    }

    private void restoreEnableState(Control control, Map<String, Object> map, String string) {
        Boolean bl;
        if (control != null && (bl = (Boolean)map.get(string)) != null) {
            control.setEnabled(bl.booleanValue());
        }
    }

    private void restoreUIState(Map<String, Object> map) {
        this.restoreEnableState((Control)this.backButton, map, "back");
        this.restoreEnableState((Control)this.nextButton, map, "next");
        this.restoreEnableState((Control)this.finishButton, map, "finish");
        this.restoreEnableState((Control)this.cancelButton, map, "cancel");
        this.restoreEnableState((Control)this.helpButton, map, "help");
        Object object = map.get("page");
        if (object != null) {
            ((ControlEnableState)object).restore();
        }
    }

    public void run(boolean bl, boolean bl2, IRunnableWithProgress iRunnableWithProgress) throws InvocationTargetException, InterruptedException {
        IProgressMonitor iProgressMonitor;
        Object object = null;
        if (this.activeRunningOperations++ == 0L) {
            object = this.aboutToStart(bl && bl2);
        }
        if ((iProgressMonitor = this.getProgressMonitor()) == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            if (!bl) {
                this.lockedUI = true;
            }
            ModalContext.run((IRunnableWithProgress)iRunnableWithProgress, (boolean)bl, (IProgressMonitor)iProgressMonitor, (Display)this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            iProgressMonitor.done();
            if (object != null) {
                this.timeWhenLastJobFinished = System.currentTimeMillis();
                this.stopped(object);
            }
            --this.activeRunningOperations;
        }
    }

    private void saveEnableStateAndSet(Control control, Map<String, Object> map, String string, boolean bl) {
        if (control != null) {
            map.put(string, control.getEnabled() ? Boolean.TRUE : Boolean.FALSE);
            control.setEnabled(bl);
        }
    }

    private Map<String, Object> saveUIState(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        this.saveEnableStateAndSet((Control)this.backButton, hashMap, "back", false);
        this.saveEnableStateAndSet((Control)this.nextButton, hashMap, "next", false);
        this.saveEnableStateAndSet((Control)this.finishButton, hashMap, "finish", false);
        this.saveEnableStateAndSet((Control)this.cancelButton, hashMap, "cancel", bl);
        this.saveEnableStateAndSet((Control)this.helpButton, hashMap, "help", false);
        if (this.currentPage != null) {
            hashMap.put("page", ControlEnableState.disable((Control)this.currentPage.getControl()));
        }
        return hashMap;
    }

    private void setDisplayCursor(Cursor cursor) {
        Shell[] shellArray = this.getShell().getDisplay().getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].setCursor(cursor);
            ++n;
        }
    }

    public void setMinimumPageSize(int n, int n2) {
        Assert.isTrue((n >= 0 && n2 >= 0 ? 1 : 0) != 0);
        this.pageContainerLayout.minimumWidth = n;
        this.pageContainerLayout.minimumHeight = n2;
    }

    public void setMinimumPageSize(Point point) {
        this.setMinimumPageSize(point.x, point.y);
    }

    public void setPageSize(int n, int n2) {
        this.pageWidth = n;
        this.pageHeight = n2;
    }

    public void setPageSize(Point point) {
        this.setPageSize(point.x, point.y);
    }

    protected void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (!this.createdWizards.contains(this.wizard)) {
            this.createdWizards.add(this.wizard);
            this.nestedWizards.add(this.wizard);
            if (this.pageContainer != null) {
                this.createPageControls();
                this.updateSizeForWizard(this.wizard);
                this.pageContainer.layout(true);
            }
        } else {
            int n = this.nestedWizards.size();
            if (n >= 2 && this.nestedWizards.get(n - 2) == this.wizard) {
                this.nestedWizards.remove(n - 1);
            } else {
                this.nestedWizards.add(this.wizard);
            }
        }
    }

    public void showPage(IWizardPage iWizardPage) {
        if (iWizardPage == null || iWizardPage == this.currentPage) {
            return;
        }
        if (!this.isMovingToPreviousPage) {
            iWizardPage.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        if (!this.doPageChanging(iWizardPage)) {
            return;
        }
        if (this.getContents() == null) {
            this.updateForPage(iWizardPage);
        } else {
            final IWizardPage iWizardPage2 = iWizardPage;
            BusyIndicator.showWhile((Display)this.getContents().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.updateForPage(iWizardPage2);
                }
            });
        }
    }

    private void updateForPage(IWizardPage iWizardPage) {
        if (this.wizard != iWizardPage.getWizard()) {
            this.setWizard(iWizardPage.getWizard());
        }
        if (iWizardPage.getControl() == null) {
            iWizardPage.createControl(this.pageContainer);
            Assert.isNotNull((Object)iWizardPage.getControl(), (String)JFaceResources.format((String)JFaceResources.getString((String)"WizardDialog.missingSetControl"), (Object[])new Object[]{iWizardPage.getName()}));
            this.updateSize(iWizardPage);
        }
        IWizardPage iWizardPage2 = this.currentPage;
        this.currentPage = iWizardPage;
        this.currentPage.setVisible(true);
        if (iWizardPage2 != null) {
            iWizardPage2.setVisible(false);
        }
        this.update();
    }

    private void showStartingPage() {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage.getControl() == null) {
            this.currentPage.createControl(this.pageContainer);
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        this.currentPage.setVisible(true);
        this.update();
    }

    private void stopped(Object object) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            if (this.wizard.needsProgressMonitor()) {
                this.progressMonitorPart.setVisible(false);
                this.progressMonitorPart.removeFromCancelComponent((Control)this.cancelButton);
            }
            Map map = (Map)object;
            this.restoreUIState(map);
            this.setDisplayCursor(null);
            if (this.useCustomProgressMonitorPart) {
                this.cancelButton.addSelectionListener((SelectionListener)this.cancelListener);
                this.cancelButton.setCursor(null);
                this.arrowCursor.dispose();
                this.arrowCursor = null;
            }
            this.waitCursor.dispose();
            this.waitCursor = null;
            Control control = (Control)map.get(FOCUS_CONTROL);
            if (control != null && !control.isDisposed()) {
                control.setFocus();
            }
        }
    }

    protected void update() {
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
    }

    public void updateButtons() {
        boolean bl = false;
        boolean bl2 = this.wizard.canFinish();
        if (this.backButton != null) {
            boolean bl3 = this.currentPage != null && this.currentPage.getPreviousPage() != null;
            this.backButton.setEnabled(bl3);
        }
        if (this.nextButton != null) {
            bl = this.currentPage != null && this.currentPage.canFlipToNextPage();
            this.nextButton.setEnabled(bl);
        }
        this.finishButton.setEnabled(bl2);
        if (bl && !bl2) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
    }

    private void updateDescriptionMessage() {
        this.pageDescription = this.currentPage.getDescription();
        this.setMessage(this.pageDescription);
    }

    public void updateMessage() {
        if (this.currentPage == null) {
            return;
        }
        this.pageMessage = this.currentPage.getMessage();
        this.pageMessageType = this.pageMessage != null && this.currentPage instanceof IMessageProvider ? ((IMessageProvider)this.currentPage).getMessageType() : 0;
        if (this.pageMessage == null) {
            this.setMessage(this.pageDescription);
        } else {
            this.setMessage(this.pageMessage, this.pageMessageType);
        }
        this.setErrorMessage(this.currentPage.getErrorMessage());
    }

    private void setShellSize(int n, int n2) {
        Rectangle rectangle = this.getShell().getBounds();
        rectangle.height = n2;
        rectangle.width = n;
        this.getShell().setBounds(this.getConstrainedShellBounds(rectangle));
    }

    protected void updateSize(IWizardPage iWizardPage) {
        if (iWizardPage == null || iWizardPage.getControl() == null) {
            return;
        }
        this.updateSizeForPage(iWizardPage);
        this.pageContainerLayout.layoutPage(iWizardPage.getControl());
    }

    public void updateSize() {
        this.updateSize(this.currentPage);
    }

    private void updateSizeForPage(IWizardPage iWizardPage) {
        Point point = this.calculatePageSizeDelta(iWizardPage);
        if (point.x > 0 || point.y > 0) {
            Shell shell = this.getShell();
            Point point2 = shell.getSize();
            this.setShellSize(point2.x + point.x, point2.y + point.y);
            this.constrainShellSize();
        }
    }

    private void updateSizeForWizard(IWizard iWizard) {
        Point point;
        Point point2 = new Point(0, 0);
        IWizardPage[] iWizardPageArray = iWizard.getPages();
        int n = 0;
        while (n < iWizardPageArray.length) {
            point = this.calculatePageSizeDelta(iWizardPageArray[n]);
            point2.x = Math.max(point2.x, point.x);
            point2.y = Math.max(point2.y, point.y);
            ++n;
        }
        if (point2.x > 0 || point2.y > 0) {
            Shell shell = this.getShell();
            point = shell.getSize();
            this.setShellSize(point.x + point2.x, point.y + point2.y);
        }
    }

    public void setNavigationString(String[] stringArray) {
        this.navigatorString = stringArray;
    }

    public void setNavigatorCurrentPage(int n) {
        if (this.pageNavigator != null) {
            this.pageNavigator.setCurruntPageIndex(n);
        }
    }

    public void redrawNavigator() {
        if (this.pageNavigator != null) {
            this.pageNavigator.redraw();
        }
    }

    public void setCTitle(String string) {
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        }
    }

    public void setCDescription(String string) {
        Label label;
        if (this.stl == null) {
            return;
        }
        Label label2 = label = this.stl.topControl == this.pageNaviTitleComp ? this.descLabelTypePageNavi : this.descLabelTypeMsg;
        if (label != null) {
            Composite composite = label.getParent();
            label.setText(string);
            composite.layout();
        }
    }

    public void updateTitleBar() {
        String string = null;
        if (this.currentPage != null) {
            string = this.currentPage.getTitle();
        }
        if (string == null) {
            string = "";
        }
        this.setTitle(string);
        if (this.currentPage != null) {
            this.setTitleImage(this.currentPage.getImage());
            this.updateDescriptionMessage();
        }
        this.updateMessage();
    }

    public void updateWindowTitle() {
        if (this.getShell() == null) {
            return;
        }
        String string = this.wizard.getWindowTitle();
        if (string == null) {
            string = "";
        }
        this.getShell().setText(string);
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    public void addPageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangedListeners.add((Object)iPageChangedListener);
    }

    public void removePageChangedListener(IPageChangedListener iPageChangedListener) {
        this.pageChangedListeners.remove((Object)iPageChangedListener);
    }

    protected void firePageChanged(final PageChangedEvent pageChangedEvent) {
        Object[] objectArray = this.pageChangedListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageChangedListener iPageChangedListener = (IPageChangedListener)objectArray[n];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPageChangedListener.pageChanged(pageChangedEvent);
                }
            });
            ++n;
        }
    }

    public void addPageChangingListener(IPageChangingListener iPageChangingListener) {
        this.pageChangingListeners.add((Object)iPageChangingListener);
    }

    public void removePageChangingListener(IPageChangingListener iPageChangingListener) {
        this.pageChangingListeners.remove((Object)iPageChangingListener);
    }

    protected void firePageChanging(final PageChangingEvent pageChangingEvent) {
        Object[] objectArray = this.pageChangingListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final IPageChangingListener iPageChangingListener = (IPageChangingListener)objectArray[n];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iPageChangingListener.handlePageChanging(pageChangingEvent);
                }
            });
            ++n;
        }
    }

    public void setVisiblePageNavigator(boolean bl) {
        this.stl.topControl = bl ? this.pageNaviTitleComp : this.pageNaviUnTitleComp;
        this.contentPanel.layout();
    }

    protected class PageContainerFillLayout
    extends Layout {
        public int marginWidth = 5;
        public int marginHeight = 5;
        public int minimumWidth = 0;
        public int minimumHeight = 0;

        public PageContainerFillLayout(int n, int n2, int n3, int n4) {
            this.marginWidth = n;
            this.marginHeight = n2;
            this.minimumWidth = n3;
            this.minimumHeight = n4;
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Point point = null;
            Control[] controlArray = composite.getChildren();
            if (controlArray.length > 0) {
                point = new Point(0, 0);
                int n3 = 0;
                while (n3 < controlArray.length) {
                    Point point2 = controlArray[n3].computeSize(n, n2, bl);
                    point.x = Math.max(point.x, point2.x);
                    point.y = Math.max(point.y, point2.y);
                    ++n3;
                }
                point.x += 2 * this.marginWidth;
                point.y += 2 * this.marginHeight;
            } else {
                Rectangle rectangle = composite.getClientArea();
                point = new Point(rectangle.width, rectangle.height);
            }
            point.x = Math.max(point.x, this.minimumWidth);
            point.y = Math.max(point.y, this.minimumHeight);
            if (n != -1) {
                point.x = n;
            }
            if (n2 != -1) {
                point.y = n2;
            }
            return point;
        }

        public Rectangle getClientArea(Composite composite) {
            Rectangle rectangle = composite.getClientArea();
            rectangle.x += this.marginWidth;
            rectangle.y += this.marginHeight;
            rectangle.width -= 2 * this.marginWidth;
            rectangle.height -= 2 * this.marginHeight;
            return rectangle;
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = this.getClientArea(composite);
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                controlArray[n].setBounds(rectangle);
                ++n;
            }
        }

        public void layoutPage(Control control) {
            control.setBounds(this.getClientArea(control.getParent()));
        }

        public void setPageLocation(Control control) {
            control.setLocation(this.marginWidth, this.marginHeight);
        }
    }
}

