/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.efluibuilder.internal.connector.ChecksumValidator;
import org.tizen.efluibuilder.internal.connector.Header;
import org.tizen.efluibuilder.internal.connector.IMessage;
import org.tizen.efluibuilder.internal.connector.message.ResponseEventMessage;
import org.tizen.efluibuilder.internal.connector.message.ResponsePaintMessage;

public final class MessageReader {
    protected Logger logger = LoggerFactory.getLogger(MessageReader.class);
    private InputStream stream = null;

    public MessageReader(InputStream inputStream) {
        this.stream = inputStream;
    }

    public IMessage read() throws IOException {
        Header header = this.readHeader();
        if (!this.isValidProtocol(header)) {
            throw new IOException("Invalid protocol : " + header.getId() + " : " + header.getVersion());
        }
        byte[] byArray = this.readMessage(header);
        if (!ChecksumValidator.isValid(header.getChecksum(), byArray)) {
            throw new IOException("Invalid checksum : " + header.getChecksum());
        }
        IMessage iMessage = null;
        if (header.getFormat() == 0) {
            iMessage = this.parseJson(byArray);
        } else if (header.getFormat() == 1) {
            iMessage = this.parseByte(byArray);
        } else {
            throw new IOException("Invalid format : " + header.getFormat());
        }
        return iMessage;
    }

    private Header readHeader() throws IOException {
        int n = Header.getSize();
        byte[] byArray = new byte[n];
        int n2 = this.stream.read(byArray, 0, n);
        if (n2 == -1) {
            throw new IOException("Socket closed.\n There is no more data because the end of the stream has been reached");
        }
        Header header = new Header();
        header.deserialize(byArray);
        return header;
    }

    private boolean isValidProtocol(Header header) {
        String string = header.getId();
        if (!string.equals("NUIB")) {
            return false;
        }
        int n = header.getVersion();
        return n == 1;
    }

    private byte[] readMessage(Header header) throws IOException {
        int n = header.getBodySize();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n != n2) {
            n3 = this.stream.read(byArray, n2, n - n2);
            n2 += n3;
        }
        return byArray;
    }

    private IMessage parseJson(byte[] byArray) {
        ResponseEventMessage responseEventMessage = new ResponseEventMessage();
        responseEventMessage.deserialize(byArray);
        return responseEventMessage;
    }

    public IMessage parseByte(byte[] byArray) {
        ResponsePaintMessage responsePaintMessage = new ResponsePaintMessage();
        responsePaintMessage.deserialize(byArray);
        return responsePaintMessage;
    }
}

