<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	<xsl:variable name="bindings"
		select="concat($current_view_name,'_bindings')" />
	<xsl:variable name="context" select="concat($current_view_name,'_context')" />
	<xsl:param name="current_view_name" />

	<xsl:template match="/">
		<xsl:variable name="data_bind_count"
			select="count(//views//view[@id=$current_view_name]//*[@data_bind != ''])" />
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views//view[@id=$current_view_name]" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="view">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
]]>
</xsl:text>

		<xsl:value-of
			select="concat('#include &quot;uib_',$current_view_name,'_bindings.h&quot;',$newline)" />

		<xsl:value-of
			select="concat('static uib_binding_info** ',$bindings,' = NULL;',$newline )"></xsl:value-of>

		<xsl:value-of
			select="concat('static int ',$current_view_name,'_binding_count;',$newline )"></xsl:value-of>

		<xsl:value-of
			select="concat('uib_',$current_view_name,'_view_context* ',$context,';',$newline)" />
		<!-- uib_binding_info** add_binding_info() definition starts -->
		<xsl:text>
<![CDATA[static uib_binding_info** add_binding_info() { 
]]>
</xsl:text>
		<xsl:value-of select="concat($tab,'uib_binding_info** bi = NULL;',$newline)" />
		<xsl:value-of select="concat($newline,$tab,'int count = 0;',$newline)" />
		<xsl:variable name="view_data_bind_count" select="count(.//*[@data_bind != ''])" />
		<xsl:value-of
			select="concat($tab,$current_view_name,'_binding_count = ',$view_data_bind_count,';',$newline)" />
		<xsl:value-of
			select="concat($tab,'bi = (uib_binding_info**) malloc(sizeof(uib_binding_info*) * ',$current_view_name,'_binding_count);',$newline,$newline)" />
		<xsl:call-template name="generate_binding_info" />
		<xsl:text><![CDATA[	return bi; 
}
]]>
</xsl:text>
		<!-- Ends -->
		<!-- uib_binding_info** get_view1_binding_info() definition starts -->
		<xsl:value-of
			select="concat('uib_binding_info** get_',$current_view_name,'_binding_info() {',$newline)" />
		<xsl:value-of
			select="concat($tab,'if (',$bindings,' == NULL) {',$newline,
				$tab,$tab,$bindings,' = add_binding_info();',$newline,
				$tab,'}',$newline,
				$tab,'return ',$bindings,';',$newline,
				'}',$newline)" />

		<!-- Ends -->
		<!-- int get_',$current_view_name,'_binding_count(); -->
		<xsl:value-of
			select="concat($newline,'int get_',$current_view_name,'_binding_count(){',$newline,
			$tab,'return ',$current_view_name,'_binding_count;',$newline,
			'}',$newline)" />
		<!-- Ends -->
		<!-- void update_view_context_refs() -->
		<xsl:value-of
			select="concat('static void update_view_context_refs() {',$newline)" />
		<xsl:call-template name="generate_update_view_context_refs" />
		<xsl:value-of select="concat('}',$newline)"></xsl:value-of>
		<!-- Ends -->
		<!-- void set_view1_view_context(uib_view1_view_context* arg_view_context) 
			definition starts -->
		<xsl:value-of
			select="concat('void set_',$current_view_name,'_view_context(uib_',$current_view_name,'_view_context* arg_view_context){',$newline,
				$tab,$context,' = arg_view_context;',$newline,
				$tab,'update_view_context_refs();',$newline,
				'}')" />
		<xsl:value-of
			select="concat($newline,'void cleanup_',$current_view_name,'_binding() {',$newline,
			$tab,'for (int i = 0; i &lt; ',$current_view_name,'_binding_count; ++i) {',$newline,
			$tab,$tab,'free(',$current_view_name,'_bindings[i]);',$newline,
			$tab,'}',$newline,
			$tab,'free(',$current_view_name,'_bindings);',$newline,
			$tab,$current_view_name,'_bindings = NULL;',$newline,
			'}',$newline)" />
		<!-- Ends -->
	</xsl:template>
	<xsl:template name="generate_binding_info">
		<xsl:for-each select=".//*[@data_bind !='']">
			<xsl:variable name="data_bind_data" select="normalize-space(./@data_bind)" />

			<xsl:variable name="binding_info_count" select="position()" />
			<xsl:variable name="binding_type"
				select="substring-before($data_bind_data,':' )" />
			<xsl:variable name="binding_element_path"
				select="concat('/',substring-after(substring-after($data_bind_data,':'),'/'))" />
			<xsl:variable name="datamodel_name"
				select="normalize-space(substring-before(substring-after($data_bind_data,':'),'/'))"></xsl:variable>
			<xsl:variable name="widget_id" select="./@id" />

			<!-- Read data bound widget type -->
			<xsl:variable name="widget_type" select="local-name()"/>
			<xsl:variable name="widget_type_enum">
				<xsl:choose>
					<xsl:when test="local-name() = 'list'">
						<xsl:value-of select="'uib_list'" />
					</xsl:when>
					<xsl:when test="local-name() = 'listitem'">
						<xsl:value-of select="'uib_listitem'" />
					</xsl:when>
					<xsl:when test="local-name() = 'label'">
						<xsl:value-of select="'uib_label'" />
					</xsl:when>
					<xsl:when test="local-name() = 'hoversel'">
						<xsl:value-of select="'uib_hoversel'" />
					</xsl:when>
					<xsl:when test="local-name() = 'hoverselitem'">
						<xsl:value-of select="'uib_hoverselitem'" />
					</xsl:when>
					<xsl:when test="local-name() = 'button'">
						<xsl:value-of select="'uib_button'" />
					</xsl:when>
					<xsl:when test="local-name() = 'check'">
						<xsl:value-of select="'uib_checkbox'" />
					</xsl:when>
					<xsl:when test="local-name() = 'radio'">
						<xsl:value-of select="'uib_radio'" />
					</xsl:when>
					<xsl:when test="local-name() = 'flipselector'">
						<xsl:value-of select="'uib_flipselector'" />
					</xsl:when>
					<xsl:when test="local-name() = 'flipselectoritem'">
						<xsl:value-of select="'uib_flipselectoritem'" />
					</xsl:when>
					<xsl:otherwise>
					<xsl:value-of select="uib_other" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:value-of
				select="concat($tab,'uib_datamodel_context* datamodel_context_binding_info',$binding_info_count,' = uib_datamodels_get_instance()->get_datamodel_context(&quot;',$datamodel_name,'&quot;);',$newline,
					$tab,'uib_binding_info* binding_info',$binding_info_count,' = (uib_binding_info *) malloc( sizeof(uib_binding_info));',$newline,
					$tab,'binding_info',$binding_info_count,'->widget = ',$context,'->',$widget_id,';',$newline,
					$tab,'binding_info',$binding_info_count,'->binding_type = uib_databindings_get_instance()->get_binding_type(&quot;',$binding_type,'&quot;);',$newline,
					$tab,'binding_info',$binding_info_count,'->dataModelContext = datamodel_context_binding_info',$binding_info_count,';',$newline,
					$tab,'binding_info',$binding_info_count,'->binding_element_path = &quot;',$binding_element_path,'&quot;;',$newline,
					$tab,'binding_info',$binding_info_count,'->widgetType = ',$widget_type_enum,';',$newline,
					$tab,'bi[count++] = binding_info',$binding_info_count,';',$newline,$newline)" />

		</xsl:for-each>
	</xsl:template>
	<xsl:template name="generate_update_view_context_refs">
		<xsl:value-of
			select="concat($tab,'if (',$bindings,' == NULL) {',$newline,
				$tab,$tab,$bindings,' = add_binding_info();',$newline,
				$tab,'} else {',$newline,
				$tab,$tab,'int count = 0;',$newline)" />
		<xsl:for-each select=".//*[@data_bind != '']">
			<xsl:variable name="widget_id" select="./@id"></xsl:variable>
			<xsl:value-of
				select="concat($tab,$tab,$bindings,'[count++]->widget = ',$context,'->',$widget_id,';',$newline)" />
		</xsl:for-each>
		<xsl:value-of select="concat($tab,'}',$newline )" />
	</xsl:template>
</xsl:stylesheet>