<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="ctxpopup" mode="ctxpopup.callback">
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'eext_object_event_callback_add(vc->', @id, ', EEXT_CALLBACK_BACK, uib_ctxpopup_back_callback, NULL);', $newline)" />
	</xsl:template>

	<xsl:template match="ctxpopup">
		<xsl:param name="parent" />
		<xsl:param name="fromView" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$fromView = 'true'">
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_ctxpopup_add(parent);', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
				<xsl:value-of select="concat($indentation, 'vc->root_container = vc->', @id, ';', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string-length($fromView) = 0">
					<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
					<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_ctxpopup_add(parent);', $newline)" />
					<xsl:value-of select="concat($indentation,'}', $newline)" />
				</xsl:if>

				<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

				<xsl:call-template name="style">
					<xsl:with-param name="style" select="@style" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>


				<xsl:if test="string-length(@direction) != 0">
					<xsl:choose>
						<xsl:when test="@direction='horizontal'">
							<xsl:value-of select="concat($indentation1, 'elm_ctxpopup_horizontal_set(vc->', @id, ', EINA_TRUE);', $newline)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($indentation1, 'elm_ctxpopup_horizontal_set(vc->', @id, ', EINA_FALSE);', $newline)" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>

				<xsl:apply-templates select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
				</xsl:apply-templates>

				<xsl:call-template name="size_hint_align_set">
					<xsl:with-param name="align_h" select="@align_h" />
					<xsl:with-param name="align_v" select="@align_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>
				<xsl:value-of select="$newline" />

				<xsl:call-template name="size_hint_weight_set">
					<xsl:with-param name="weight_h" select="@weight_h" />
					<xsl:with-param name="weight_v" select="@weight_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>
				<xsl:value-of select="$newline" />

				<xsl:call-template name="disable">
					<xsl:with-param name="disable" select="@disable" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>

				<xsl:value-of
					select="concat($indentation1, 'elm_ctxpopup_direction_priority_set(vc->', @id, ', ELM_CTXPOPUP_DIRECTION_DOWN, ELM_CTXPOPUP_DIRECTION_UP, ELM_CTXPOPUP_DIRECTION_LEFT, ELM_CTXPOPUP_DIRECTION_RIGHT);', $newline)" />

				<xsl:apply-templates mode="visible" select="current()">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
				</xsl:apply-templates>
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
