/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.renderer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.tizen.efluibuilder.internal.connector.ConnectorFactory;
import org.tizen.efluibuilder.internal.connector.IConnector;
import org.tizen.efluibuilder.internal.renderer.Renderer;
import org.tizen.efluibuilder.renderer.IRenderer;

public final class RendererFactoryImpl {
    private static RendererFactoryImpl instance = null;
    private Map<Integer, IRenderer> renderers = new HashMap<Integer, IRenderer>();

    public static synchronized RendererFactoryImpl getDefault() {
        if (instance == null) {
            instance = new RendererFactoryImpl();
        }
        return instance;
    }

    private RendererFactoryImpl() {
    }

    private int createId() {
        int n = 0;
        while (this.renderers.containsKey(n)) {
            ++n;
        }
        return n;
    }

    public IRenderer create(String string, String string2, String string3) throws IOException {
        ConnectorFactory connectorFactory = ConnectorFactory.getDefault();
        IConnector iConnector = null;
        iConnector = connectorFactory.create(string, string2);
        Renderer renderer = null;
        if (iConnector != null) {
            renderer = new Renderer(iConnector);
            int n = this.createId();
            renderer.setId(n);
            renderer.setVersion(string);
            renderer.setProfile(string2);
            renderer.setProject(string3);
            this.renderers.put(n, renderer);
        }
        return renderer;
    }

    void destroy(IRenderer iRenderer) {
        int n = iRenderer.getId();
        this.renderers.remove(n);
        ConnectorFactory connectorFactory = ConnectorFactory.getDefault();
        String string = ((Renderer)iRenderer).getVersion();
        String string2 = ((Renderer)iRenderer).getProfile();
        connectorFactory.destroy(string, string2);
    }
}

