/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.utility;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.tizen.common.util.Assert;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static ImageDescriptor getImageDescriptor(URL uRL) {
        ImageLoader imageLoader = new ImageLoader();
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.valueOf(iOException.getMessage()) + " : " + uRL.toString());
        }
        ImageData[] imageDataArray = imageLoader.load(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)imageDataArray[0]);
        return imageDescriptor;
    }

    public static ImageDescriptor getImageDescriptor(String string, String string2) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)string, (String)string2);
    }

    public static Image createImage(String string, String string2) {
        ImageDescriptor imageDescriptor = ResourceUtil.getImageDescriptor(string, string2);
        if (imageDescriptor == null) {
            return null;
        }
        return imageDescriptor.createImage();
    }

    public static URI getURI(String string, String string2) {
        URL uRL = ResourceUtil.getURL(string, string2);
        URI uRI = ResourceUtil.getURI(uRL);
        return uRI;
    }

    public static URL getURL(String string, String string2) {
        Bundle bundle = Platform.getBundle((String)string);
        Assert.notNull((Object)bundle, (String)("Invalid plugin id : " + string));
        URL uRL = bundle.getResource(string2);
        Assert.notNull((Object)uRL, (String)("Invalid path : " + string2));
        URL uRL2 = null;
        try {
            uRL2 = FileLocator.toFileURL((URL)uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return uRL2;
    }

    private static URI getURI(URL uRL) {
        URI uRI = null;
        try {
            uRI = URIUtil.toURI((URL)uRL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException.getMessage());
        }
        return uRI;
    }

    public static boolean isAvailableURI(String string, String string2) {
        Bundle bundle = Platform.getBundle((String)string);
        return bundle != null && bundle.getResource(string2) != null;
    }
}

