/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uibuilder.tizenfile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.uibuilder.tizenfile.TizenFileFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TizenFileReader {
    public static Document readFile(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(inputStream);
        return document;
    }

    public static Document readFile(String string) throws IOException, ParserConfigurationException, SAXException {
        Document document = null;
        document = TizenFileReader.readFile(new File(string).toURI().toURL());
        return document;
    }

    public static Document readFile(URL uRL) throws IOException, ParserConfigurationException, SAXException {
        return TizenFileReader.readFile(uRL.openStream());
    }

    public static Document readFileString(String string) throws ParserConfigurationException, SAXException, IOException {
        return TizenFileReader.readFile(new ByteArrayInputStream(string.getBytes("UTF-8")));
    }

    private static boolean validate(Document document, String string, String string2) {
        if (document == null) {
            return false;
        }
        Element element = document.getDocumentElement();
        TizenFileFormatter tizenFileFormatter = new TizenFileFormatter(element);
        if (!tizenFileFormatter.isValidate()) {
            return false;
        }
        if (!tizenFileFormatter.getType().equals(string2)) {
            return false;
        }
        return tizenFileFormatter.getVersion().equals(string);
    }

    public static Document readFile(InputStream inputStream, String string, String string2) throws ParserConfigurationException, SAXException, IOException {
        Document document = TizenFileReader.readFile(inputStream);
        if (!TizenFileReader.validate(document, string, string2)) {
            return null;
        }
        return document;
    }

    public static Document readFile(String string, String string2, String string3) throws IOException, ParserConfigurationException, SAXException {
        Document document = TizenFileReader.readFile(string);
        if (!TizenFileReader.validate(document, string2, string3)) {
            return null;
        }
        return document;
    }

    public static Document readFile(URL uRL, String string, String string2) throws IOException, ParserConfigurationException, SAXException {
        Document document = TizenFileReader.readFile(uRL);
        if (!TizenFileReader.validate(document, string, string2)) {
            return null;
        }
        return document;
    }

    public static Document readFileString(String string, String string2, String string3) throws ParserConfigurationException, SAXException, IOException {
        Document document = TizenFileReader.readFileString(string);
        if (!TizenFileReader.validate(document, string2, string3)) {
            return null;
        }
        return document;
    }
}

