/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.renderer;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.tizen.efluibuilder.internal.connector.Connector;
import org.tizen.efluibuilder.internal.connector.ConnectorEvent;
import org.tizen.efluibuilder.internal.connector.IConnector;
import org.tizen.efluibuilder.internal.connector.IConnectorListener;
import org.tizen.efluibuilder.internal.connector.IMessage;
import org.tizen.efluibuilder.internal.connector.message.RequestCommandMessage;
import org.tizen.efluibuilder.internal.connector.message.ResponseEventMessage;
import org.tizen.efluibuilder.internal.connector.message.ResponsePaintMessage;
import org.tizen.efluibuilder.internal.renderer.AbstractRenderer;
import org.tizen.efluibuilder.internal.renderer.Arguments;
import org.tizen.efluibuilder.internal.renderer.RendererFactoryImpl;
import org.tizen.efluibuilder.internal.renderer.command.CreateCommand;
import org.tizen.efluibuilder.internal.renderer.command.DestroyCommand;
import org.tizen.efluibuilder.internal.renderer.command.GetAllWidgetPositionsCommand;
import org.tizen.efluibuilder.internal.renderer.command.GetGroupNamesCommand;
import org.tizen.efluibuilder.internal.renderer.command.GetPlaceholderPositionsCommand;
import org.tizen.efluibuilder.internal.renderer.command.GetStyleNamesCommand;
import org.tizen.efluibuilder.internal.renderer.command.ICommand;
import org.tizen.efluibuilder.internal.renderer.command.OverlayThemeCommand;
import org.tizen.efluibuilder.internal.renderer.command.RemoveStyleNameCommand;
import org.tizen.efluibuilder.internal.renderer.command.RenderCommand;
import org.tizen.efluibuilder.internal.renderer.command.RendererCommand;
import org.tizen.efluibuilder.renderer.IArguments;
import org.tizen.efluibuilder.renderer.event.RenderEvent;
import org.tizen.efluibuilder.renderer.event.ReplyEvent;

public final class Renderer
extends AbstractRenderer {
    private IConnector connector = null;
    private ConnectorListener connectorListener = new ConnectorListener();
    private String renderType = null;
    private String renderData = null;

    @Override
    public boolean isRenderable() {
        return this.connector != null && this.connector instanceof Connector && ((Connector)this.connector).isConnected();
    }

    public Renderer(IConnector iConnector) {
        this.connector = iConnector;
        this.create();
    }

    private void create() {
        this.connector.addConnectorListener(this.connectorListener);
    }

    private void setRenderType(String string) {
        this.renderType = string;
    }

    private void setRenderData(String string) {
        this.renderData = string;
    }

    @Override
    public void create(int n, int n2, String string, String string2) {
        this.setSize(n, n2);
        Arguments arguments = new Arguments();
        arguments.setId("CMD_CREATE");
        arguments.addArg(0, n);
        arguments.addArg(1, n2);
        arguments.addArg(2, this.getProject());
        arguments.addArg(3, this.getProfile());
        arguments.addArg(4, string);
        arguments.addArg(5, string2);
        this.request(arguments);
    }

    @Override
    public void destroy() {
        Arguments arguments = new Arguments();
        arguments.setId("CMD_DESTROY");
        this.request(arguments);
        this.connector.removeConnectorListener(this.connectorListener);
        RendererFactoryImpl rendererFactoryImpl = RendererFactoryImpl.getDefault();
        rendererFactoryImpl.destroy(this);
    }

    @Override
    public void render(String string, String string2) {
        Point point = this.getSize();
        int n = point.x;
        int n2 = point.y;
        this.setRenderType(string);
        this.setRenderData(string2);
        Arguments arguments = new Arguments();
        arguments.setId("CMD_RENDER");
        arguments.addArg(0, n);
        arguments.addArg(1, n2);
        arguments.addArg(2, string);
        arguments.addArg(3, string2);
        this.request(arguments);
    }

    @Override
    public void requestGetGroupNames(String string) {
        Arguments arguments = new Arguments();
        arguments.setId("CMD_GET_GROUP_NAMES");
        arguments.addArg(0, string);
        this.request(arguments);
    }

    @Override
    public void requestGetStyleNames(String string) {
        Arguments arguments = new Arguments();
        arguments.setId("CMD_GET_STYLE_NAMES");
        arguments.addArg(0, string);
        this.request(arguments);
    }

    @Override
    public void requestRemoveStyleName(String string, String string2, String string3, String string4) {
        Arguments arguments = new Arguments();
        arguments.setId("CMD_REMOVE_STYLE_NAME");
        arguments.addArg(0, string);
        arguments.addArg(1, string2);
        arguments.addArg(2, string3);
        arguments.addArg(3, string4);
        this.request(arguments);
    }

    @Override
    public void requestOverlayTheme(String string) {
        Arguments arguments = new Arguments();
        arguments.setId("CMD_OVERLAY_THEME");
        arguments.addArg(0, string);
        this.request(arguments);
    }

    @Override
    protected void createCommands() {
        RendererCommand rendererCommand = null;
        rendererCommand = new CreateCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new DestroyCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new RenderCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new GetAllWidgetPositionsCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new GetPlaceholderPositionsCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new GetGroupNamesCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new GetStyleNamesCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new RemoveStyleNameCommand(this);
        this.registerCommand(rendererCommand);
        rendererCommand = new OverlayThemeCommand(this);
        this.registerCommand(rendererCommand);
    }

    @Override
    public void resize(int n, int n2) {
        this.setSize(n, n2);
        this.render(this.renderType, this.renderData);
    }

    public void requestCommand(ICommand iCommand) {
        String string = iCommand.serialize();
        RequestCommandMessage requestCommandMessage = new RequestCommandMessage();
        requestCommandMessage.setId(this.getId());
        requestCommandMessage.setName(iCommand.getId());
        requestCommandMessage.setData(string);
        this.connector.send(requestCommandMessage);
    }

    private void handleConnetorEvent(ConnectorEvent connectorEvent) {
        if (this.getId() != connectorEvent.getId()) {
            return;
        }
        int n = connectorEvent.getType();
        IMessage iMessage = connectorEvent.getMessage();
        switch (n) {
            case 11: {
                ResponsePaintMessage responsePaintMessage = (ResponsePaintMessage)iMessage;
                int n2 = responsePaintMessage.getWidth();
                int n3 = responsePaintMessage.getHeight();
                int n4 = responsePaintMessage.getDepth();
                byte[] byArray = responsePaintMessage.getImageBuffer();
                PaletteData paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                ImageData imageData = new ImageData(n2, n3, n4, paletteData, 4, byArray);
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)imageData);
                RenderEvent renderEvent = new RenderEvent();
                renderEvent.renderer = this;
                renderEvent.imageDescriptor = imageDescriptor;
                this.fireReplyRender(renderEvent);
                return;
            }
            case 12: {
                ResponseEventMessage responseEventMessage = (ResponseEventMessage)iMessage;
                String string = responseEventMessage.getName();
                String string2 = responseEventMessage.getData();
                ReplyEvent replyEvent = new ReplyEvent();
                replyEvent.name = string;
                replyEvent.contents = string2;
                this.handleReceiveEvent(replyEvent);
                return;
            }
        }
        logger.error("Unknown Event");
    }

    @Override
    protected boolean handleReply(IArguments iArguments) {
        if (iArguments.getId().equals("EVENT_CREATE")) {
            this.fireEvent(iArguments);
        } else if (iArguments.getId().equals("EVENT_DESTROY")) {
            this.fireEvent(iArguments);
        } else {
            if (iArguments.getId().equals("EVENT_GET_ALL_WIDGET_POSITIONS")) {
                this.fireEvent(iArguments);
                return true;
            }
            if (iArguments.getId().equals("EVENT_GET_PLACEHOLDER_POSITIONS")) {
                this.fireEvent(iArguments);
                return true;
            }
            if (iArguments.getId().equals("EVENT_GET_GROUP_NAMES")) {
                this.fireEvent(iArguments);
                return true;
            }
            if (iArguments.getId().equals("EVENT_GET_STYLE_NAMES")) {
                this.fireEvent(iArguments);
                return true;
            }
            if (iArguments.getId().equals("EVENT_REMOVE_STYLE_NAME")) {
                this.fireEvent(iArguments);
                return true;
            }
            if (iArguments.getId().equals("EVENT_OVERLAY_THEME")) {
                this.fireEvent(iArguments);
                return true;
            }
        }
        return false;
    }

    private class ConnectorListener
    implements IConnectorListener {
        private ConnectorListener() {
        }

        @Override
        public void receiveEvent(ConnectorEvent connectorEvent) {
            Renderer.this.handleConnetorEvent(connectorEvent);
        }
    }
}

