/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.efluibuilder.utility.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CodeGeneratorUtil {
    private static Logger logger = LoggerFactory.getLogger(CodeGeneratorUtil.class);
    private static final float SUPPORT_RM_VERSION = 2.4f;

    public static String getProfile(IProject iProject) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        IFile iFile = iProject.getFile(".uproject");
        File file = new File(iFile.getLocation().toString());
        Document document = CodeGeneratorUtil.loadXML(file);
        Assert.notNull((Object)document);
        String string = XMLUtil.getValue((Document)document, (String)"/properties/shape");
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)iProject);
        String string2 = tizenProjectDescription.getProfileName();
        if (string.equals("circle")) {
            string2 = "wearable-circle";
        }
        return string2;
    }

    public static String getProjectVersion(IProject iProject) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        IFile iFile = iProject.getFile(".uproject");
        File file = new File(iFile.getLocation().toString());
        Document document = CodeGeneratorUtil.loadXML(file);
        Assert.notNull((Object)document);
        String string = null;
        string = XMLUtil.isExistValue((Document)document, (String)"/properties/version") ? XMLUtil.getValue((Document)document, (String)"/properties/version") : "0.0";
        return string;
    }

    public static Document loadXML(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    public static NodeList getViews(Document document) throws XPathExpressionException {
        String string = "/document/views/view";
        NodeList nodeList = CodeGeneratorUtil.getNodes(document, string);
        return nodeList;
    }

    public static NodeList getNodes(Document document, String string) throws XPathExpressionException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = CodeGeneratorUtil.class.getClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
        return nodeList;
    }

    public static Node getView(Document document, String string) throws XPathExpressionException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        NodeList nodeList = CodeGeneratorUtil.getViews(document);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string2 = CodeGeneratorUtil.getViewId(node);
            if (string.equals(string2)) {
                return node;
            }
            ++n;
        }
        return null;
    }

    public static String getStartupView(Document document) throws XPathExpressionException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = CodeGeneratorUtil.class.getClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        String string = "/document/views/@startup";
        Object object = xPath.evaluate(string, document, XPathConstants.NODE);
        Assert.notNull((Object)object);
        Assert.isTrue((boolean)(object instanceof Node));
        Node node = (Node)object;
        String string2 = node.getTextContent();
        return string2;
    }

    public static Writer getDestinationWriter(File file, String string) throws IOException {
        File file2 = new File(file, string);
        FileWriter fileWriter = new FileWriter(file2);
        return fileWriter;
    }

    public static InputStream openStream(String string) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.tizen.efluibuilder.codegenerator");
        if (bundle == null) {
            logger.error("Invalid bundle");
            return null;
        }
        URL uRL = bundle.getResource(string);
        if (uRL == null) {
            logger.error("Invalid resource");
            return null;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream == null) {
            logger.error("Invalid stream");
            return null;
        }
        return inputStream;
    }

    public static String getViewId(Node node) {
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node2 = namedNodeMap.item(n);
            if (node2.getNodeName().equals("id")) {
                string = node2.getNodeValue();
            }
            ++n;
        }
        return string;
    }

    public static boolean isVersionRMSupport(String string) {
        float f = Float.parseFloat(string = string.substring(0, 3));
        return f >= 2.4f;
    }

    public static void createDirectoy(File file, String string) {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    public static void generateCode(Node node, Writer writer, StreamSource streamSource, String string, String string2, String string3, String string4) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String string, String string2) throws TransformerException {
                String string3 = "res/" + string;
                try {
                    InputStream inputStream = CodeGeneratorUtil.openStream(string3);
                    return new StreamSource(inputStream);
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage());
                    return null;
                }
            }
        });
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setParameter(string, string2);
        if (string3 != null) {
            transformer.setParameter("is_version_rm_support", string3);
        }
        if (string4 != null) {
            transformer.setParameter("profile", string4);
        }
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
        writer.close();
    }

    public static String getNodeId(Node node, String string) {
        String string2 = null;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            string2 = node2.getTextContent();
        }
        return string2;
    }
}

