/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorException;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorUtil;
import org.tizen.efluibuilder.codegenerator.DataBindingCodeGenerator;
import org.tizen.efluibuilder.codegenerator.view.ViewCodeGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ManagedCodeGenerator {
    protected static Logger logger = LoggerFactory.getLogger(ManagedCodeGenerator.class);
    public static Map<String, String> managedCodeMap = ManagedCodeGenerator.initManagedCodeMap();
    private IProject project = null;
    private File targetDirectory = null;
    private String startUpView = null;
    private String profile = null;
    private String isRMSupportVersion = null;
    private boolean isWidgetProject = false;
    private boolean hasCustomTheme = false;
    private String platformVersion = null;

    private static Map<String, String> initManagedCodeMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "res/";
        hashMap.put("src/managed/inc/uib_app_manager.h", String.valueOf(string) + "inc/uib_app_manager_header.xsl");
        hashMap.put("src/managed/src/manager/uib_app_manager.c", String.valueOf(string) + "src/uib_app_manager_source.xsl");
        hashMap.put("src/managed/inc/uib_view_manager.h", String.valueOf(string) + "inc/uib_view_manager_header.xsl");
        hashMap.put("src/managed/src/manager/uib_view_manager.c", String.valueOf(string) + "src/uib_view_manager_source.xsl");
        hashMap.put("src/managed/inc/g_inc_uib.h", String.valueOf(string) + "inc/g_inc_uib_header.xsl");
        hashMap.put("src/managed/inc/uib_util.h", String.valueOf(string) + "inc/uib_util_header.xsl");
        hashMap.put("src/managed/src/utils/uib_util.c", String.valueOf(string) + "src/uib_util_source.xsl");
        hashMap.put("src/managed/inc/uib_views_inc.h", String.valueOf(string) + "inc/uib_views_inc_header.xsl");
        hashMap.put("src/managed/inc/uib_views.h", String.valueOf(string) + "inc/uib_views_header.xsl");
        hashMap.put("src/managed/src/view/uib_views.c", String.valueOf(string) + "src/uib_views_source.xsl");
        hashMap.put("src/managed/inc/view_data.h", String.valueOf(string) + "inc/view_data_header.xsl");
        return Collections.unmodifiableMap(hashMap);
    }

    public ManagedCodeGenerator(IProject iProject) throws CodeGeneratorException {
        this.project = iProject;
        try {
            this.profile = CodeGeneratorUtil.getProfile(iProject);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CodeGeneratorException(xPathExpressionException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new CodeGeneratorException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CodeGeneratorException(parserConfigurationException.getMessage());
        }
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)iProject);
        this.platformVersion = tizenProjectDescription.getVersion();
        this.isRMSupportVersion = String.valueOf(CodeGeneratorUtil.isVersionRMSupport(this.platformVersion));
        this.targetDirectory = new File(iProject.getLocation().toString());
        this.isWidgetProject = ProjectUtil.getTizenProjectType((IProject)iProject).isNativeWidgetApplicationProject();
        this.hasCustomTheme = iProject.exists((IPath)new Path("res/theme/custom_theme.edj"));
    }

    public void generate() throws CodeGeneratorException {
        IFile iFile = this.project.getFile("layout/layout.xml");
        File file = new File(iFile.getLocation().toString());
        try {
            Document document = CodeGeneratorUtil.loadXML(file);
            Assert.notNull((Object)document);
            this.startUpView = CodeGeneratorUtil.getStartupView(document);
            this.deleteOldFilesAndCreateDirectories(this.targetDirectory);
            Set<String> set = managedCodeMap.keySet();
            for (String object2 : set) {
                String string = managedCodeMap.get(object2);
                Writer writer = CodeGeneratorUtil.getDestinationWriter(this.targetDirectory, object2);
                InputStream inputStream = CodeGeneratorUtil.openStream(string);
                StreamSource streamSource = new StreamSource(inputStream);
                this.generateCode(document, writer, streamSource);
                writer.close();
                inputStream.close();
            }
            NodeList nodeList = CodeGeneratorUtil.getViews(document);
            this.generateViewsFiles(nodeList);
            this.generateDataBindingCode(nodeList, document);
            this.refreshManaged();
        }
        catch (SAXException sAXException) {
            throw new CodeGeneratorException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CodeGeneratorException(parserConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new CodeGeneratorException(transformerException.getMessage());
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CodeGeneratorException(xPathExpressionException.getMessage());
        }
    }

    public void clean() throws CodeGeneratorException {
        File file = new File(this.targetDirectory, "src/managed/");
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                throw new CodeGeneratorException(iOException.getMessage());
            }
        }
        this.refreshManaged();
    }

    private void generateViewsFiles(NodeList nodeList) throws CodeGeneratorException {
        ViewCodeGenerator viewCodeGenerator = new ViewCodeGenerator(this.project);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = CodeGeneratorUtil.getViewId(node);
            viewCodeGenerator.generate(string);
            ++n;
        }
    }

    private void deleteOldFilesAndCreateDirectories(File file) throws CodeGeneratorException {
        this.clean();
        this.createDirectories(file);
    }

    private void createDirectories(File file) {
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/inc/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/view/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/utils/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/manager/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/connection/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/inc/databinding/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/databinding/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/databinding//widgets");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/databinding//datasources");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/databinding//datamodels");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/databinding//viewbindings");
    }

    private void generateCode(Node node, Writer writer, StreamSource streamSource) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        if (this.startUpView != null) {
            transformer.setParameter("startup_view", this.startUpView);
        }
        if (this.profile != null) {
            transformer.setParameter("profile", this.profile);
        }
        if (this.isRMSupportVersion != null) {
            transformer.setParameter("is_version_rm_support", this.isRMSupportVersion);
        }
        transformer.setParameter("is_widget_project", this.isWidgetProject);
        transformer.setParameter("has_custom_theme", this.hasCustomTheme);
        if (this.platformVersion != null) {
            transformer.setParameter("version", this.platformVersion);
        }
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
    }

    private void refreshManaged() throws CodeGeneratorException {
        IFolder iFolder = this.project.getFolder("src/managed/");
        if (iFolder != null) {
            try {
                iFolder.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                throw new CodeGeneratorException(coreException.getMessage());
            }
        }
    }

    private void generateDataBindingCode(NodeList nodeList, Document document) throws TransformerException, IOException {
        IFile iFile = this.project.getFile("layout/.databinding");
        File file = new File(iFile.getLocation().toString());
        Document document2 = null;
        try {
            document2 = CodeGeneratorUtil.loadXML(file);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        DataBindingCodeGenerator dataBindingCodeGenerator = new DataBindingCodeGenerator(this.targetDirectory, document, document2, this.isRMSupportVersion, this.profile);
        dataBindingCodeGenerator.generate();
    }
}

