<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="popup" mode="popup.callback">
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'eext_object_event_callback_add(vc->', @id, ', EEXT_CALLBACK_BACK, eext_popup_back_cb, NULL);', $newline)" />
	</xsl:template>

	<xsl:template match="popup">
		<xsl:param name="parent" />
		<xsl:param name="fromView" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$fromView = 'true'">
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_popup_add(parent);', $newline)" />



				<xsl:value-of select="concat($indentation,'}', $newline)" />
				<xsl:value-of select="concat($indentation, 'vc->root_container = vc->', @id, ';', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string-length($fromView) = 0">
					<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
					<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_popup_add(parent);', $newline)" />
					<xsl:value-of select="concat($indentation,'}', $newline)" />
				</xsl:if>

				<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />
				<xsl:call-template name="style">
					<xsl:with-param name="style" select="@style" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>

				<xsl:call-template name="colors">
					<xsl:with-param name="colors" select="@colors" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
					<xsl:with-param name="widgettype" />
				</xsl:call-template>

				<xsl:value-of select="concat($indentation1, 'elm_popup_align_set(vc->', @id, ', ELM_NOTIFY_ALIGN_FILL, 1.0);', $newline)" />

				<xsl:if test="string-length(@title) != 0">
					<xsl:value-of select="concat($indentation1, 'elm_object_part_text_set(vc->', @id, ', &quot;title,text&quot;, &quot;', @title, '&quot;);', $newline)" />
				</xsl:if>
				<xsl:if test="string-length(@timeout) != 0">
					<xsl:value-of select="concat($indentation1, 'elm_popup_timeout_set(vc->', @id, ', ', @timeout, ');', $newline)" />
				</xsl:if>


				<xsl:call-template name="size_hint_weight_set">
					<xsl:with-param name="weight_h" select="@weight_h" />
					<xsl:with-param name="weight_v" select="@weight_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>


				<xsl:apply-templates select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
				</xsl:apply-templates>

				<xsl:apply-templates mode="popup_pack" select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="height" select="@height" />
				</xsl:apply-templates>

				<xsl:if test="@disable = 'true'">
					<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:if>
				<xsl:apply-templates mode="visible" select="current()">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
				</xsl:apply-templates>
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*" mode="popup_pack">
		<xsl:param name="parent" />
		<xsl:param name="height" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'evas_object_size_hint_min_set(vc->', @id, ', -1, ELM_SCALE_SIZE(', $height, '));', 					'&#xD;'
									)" />

		<xsl:value-of select="concat($indentation, 'elm_object_content_set(vc->', $parent, ', vc->', @id, ');', 					'&#xD;'
									)" />
	</xsl:template>
</xsl:stylesheet>
