<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Ignore empty datamodels or datamodels tied to empty datasource -->
		<xsl:variable name="datamodel_count"
			select="count(//dataBinding//dataModel[@dataSource !=''][@modelType != 'Empty'])" />
		<xsl:if test="$datamodel_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
 * This file was generated by UI Builder.
 * This file will be auto-generated each and everytime you save your project.
 * Do not hand edit this file.
 ********************************************************************************/

#ifndef MANAGED_INC_UIB_DATAMODELS_H_
#define MANAGED_INC_UIB_DATAMODELS_H_
#include "uib_databinding_common.h"
#include "uib_datasources.h"

typedef struct {
	void** root_element;
	uib_datasource_instance* datasource;
	char* dataModelName;
} uib_datamodel_context;

typedef struct {
	bool _is_init;
	uib_datamodel_context* (*get_datamodel_context)(const char*);
	void (*register_attached_datasource_update_cb)(void (*)());
	void (*free_all_datamodels)();
} uib_datamodels_st;

uib_datamodels_st* uib_datamodels_get_instance();

#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
