<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
	<xsl:template match="gengrid">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_gengrid_add(vc->',$parent,');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />

		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:if test="string-length(@item_size_w) != 0 and string-length(@item_size_h) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_gengrid_item_size_set(vc->', @id, ',', @item_size_w, ',' , @item_size_h,');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@direction) != 0">
			<xsl:choose>
				<xsl:when test="@direction='horizontal'">
					<xsl:value-of select="concat($indentation1, 'elm_gengrid_horizontal_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_gengrid_horizontal_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="string-length(@multi_select) != 0"><!-- default: true -->
			<xsl:if test="@multi_select = 'true'">
				<xsl:value-of select="concat($indentation1, 'elm_gengrid_multi_select_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:if>
			<xsl:if test="@multi_select = 'false'">
				<xsl:value-of select="concat($indentation1, 'elm_gengrid_multi_select_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:if>
		</xsl:if>

		<xsl:if test="string-length(@select_mode) != 0">
			<xsl:variable name="rconv_key" select="concat('select_mode', ':', @select_mode)" />
			<xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
			<xsl:choose>
				<xsl:when test="string-length($rconv_value) != 0">
					<xsl:value-of select="concat($indentation1, 'elm_gengrid_select_mode_set(vc->', @id, ', (Elm_Object_Select_Mode)' ,$rconv_value,');', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_genlist_select_mode_set(vc->', @id, ', ' ,@select_mode,');', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:if test="string-length(@scrollbar_h) != 0 and string-length(@scrollbar_v) != 0">
			<xsl:variable name="scrollbar_h_key" select="concat('scrollbar_h', ':', @scrollbar_h)" />
			<xsl:variable name="scrollbar_h_value" select="exslt:node-set($value_map)//entry[@key=$scrollbar_h_key]" />
			<xsl:variable name="scrollbar_v_key" select="concat('scrollbar_v', ':', @scrollbar_v)" />
			<xsl:variable name="scrollbar_v_value" select="exslt:node-set($value_map)//entry[@key=$scrollbar_v_key]" />
			<xsl:choose>
				<xsl:when test="string-length($scrollbar_h_value) != 0 and string-length($scrollbar_v_value) !=0">
					<xsl:value-of
						select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', (Elm_Scroller_Policy)', $scrollbar_h_value, ', (Elm_Scroller_Policy)', $scrollbar_v_value, ');', $newline)" />
				</xsl:when>
				<xsl:when test="string-length($scrollbar_h_value) = 0 and string-length($scrollbar_v_value) !=0">
					<xsl:value-of
						select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', ', @scrollbar_h, ', (Elm_Scroller_Policy)', $scrollbar_v_value, ');', $newline)" />
				</xsl:when>
				<xsl:when test="string-length($scrollbar_h_value) != 0 and string-length($scrollbar_v_value) =0">
					<xsl:value-of
						select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', (Elm_Scroller_Policy)', $scrollbar_h_value, ', ', @scrollbar_v, ');', $newline)" />
				</xsl:when>
				<xsl:when test="string-length($scrollbar_h_value) = 0 and string-length($scrollbar_v_value) =0">
					<xsl:value-of select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', ', @scrollbar_h, ', ', @scrollbar_v, ');', $newline)" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>

		<!-- TODO remove comments after check api -->
		<!-- <xsl:if test="string-length(@scroll_loop) != 0"> <xsl:if test="@scroll_loop = 'true'"> <xsl:value-of select="concat($indentation1, 'elm_object_scroll_item_loop_enabled_set(vc->', 
			@id, ', EINA_TRUE);', $newline)" /> </xsl:if> <xsl:if test="@scroll_loop = 'false'"> <xsl:value-of select="concat($indentation1, 'elm_object_scroll_item_loop_enabled_set(vc->', 
			@id, ', EINA_FALSE);', $newline)" /> </xsl:if> </xsl:if> -->

		<xsl:if test="string-length(@style) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_object_style_set(vc->' , @id, ',', '&#34;', @style, '&#34;', ');', $newline)" />
		</xsl:if>
		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
		</xsl:apply-templates>
		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>
</xsl:stylesheet>
