<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="view.comment">
		<xsl:text><![CDATA[
/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and every time you save your project.
* Do not hand edit this file.
********************************************************************************/
]]></xsl:text>
	</xsl:template>
    <xsl:param name="current_view_name"></xsl:param>
    <xsl:template match="/">
        <xsl:apply-templates select="/document/views/view[@id=$current_view_name]" />
    </xsl:template>
	<xsl:template name="view.connection.include">
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'app_main.h', '&#34;')" />
		<xsl:value-of select="$newline" />
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'uib_views_inc.h', '&#34;')" />
		<xsl:value-of select="$newline" />
		<xsl:value-of select="$newline" />
	</xsl:template>
	<xsl:template name="view.connection.definition">
		<xsl:apply-templates select="*" mode="event.definition" />
	</xsl:template>

	<xsl:template match="*" mode="event.definition">
		<xsl:apply-templates select="event" />
		<xsl:apply-templates select="*" mode="event.definition" />
	</xsl:template>

	<xsl:template match="event">
		<xsl:apply-templates select="@*" mode="definition">
			<xsl:with-param name="view" select="./ancestor::view/@id" />
			<xsl:with-param name="title" select="@title" />
			<xsl:with-param name="target" select="@target" />
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="@*" mode="definition">
		<xsl:param name="level">
			<xsl:value-of select="0" />
		</xsl:param>
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:param name="view" />
		<xsl:param name="title" />
		<xsl:param name="target" />
		<xsl:if test="starts-with(name(.), 'connection_wrapper')">
			<xsl:value-of select="concat($indentation, 'void ',  ., '(uib_' , $view, '_view_context *vc, Evas_Object *obj, void *event_info){', $newline)" />
		</xsl:if>

		<xsl:if test="string-length($target)!=0">
			<xsl:if test="starts-with(name(.), 'function_name')">
				<xsl:variable name="titleString">
					<xsl:value-of select="concat('&quot;',$title,'&quot;')" />
				</xsl:variable>
				<xsl:variable name="targetString">
					<xsl:value-of select="concat('&quot;',$target,'&quot;')" />
				</xsl:variable>
                <xsl:variable name="viewType">
                    <xsl:value-of select="//views/view[@id=$target]/@type" />
                </xsl:variable>
                <xsl:variable name="ctxType">
                    <xsl:value-of select="boolean(//views/view[@id=$target]/ctxpopup)" />
                </xsl:variable>
                <xsl:variable name="firstParam">
	                <xsl:choose>
	                    <xsl:when test="(($viewType = 'popup') and ($ctxType = 'true'))">
	                    	<xsl:value-of select="'pc'" />
	                    </xsl:when>
	                    <xsl:when test="(($viewType = 'popup') and ($ctxType = 'false'))">
	                    	<xsl:value-of select="'pc'" />
	                    </xsl:when>
	                    <xsl:otherwise>
	                    	<xsl:value-of select="'navi_item'" />
	                    </xsl:otherwise>
	                </xsl:choose>
                </xsl:variable>
                <xsl:value-of select="concat($indentation1,.,'(vc, ','obj, ','event_info);',$newline)" />
                <xsl:choose>
                    <xsl:when test="(($viewType = 'popup') and ($ctxType = 'true'))">
                        <xsl:variable name="ctxPopupId">
                            <xsl:value-of select="//views/view[@id=$target]/ctxpopup/@id" />
                        </xsl:variable>
                        <xsl:value-of select="concat($indentation1,'uib_popup_context* pc = uib_create_ctxpopup(&quot;',$ctxPopupId,'&quot; , e_ctxpopup_position_default, obj, ','0, ','0);',$newline)" />
                    </xsl:when>
                    <xsl:when test="(($viewType = 'popup') and ($ctxType = 'false'))">
                        <xsl:variable name="popupId">
                            <xsl:value-of select="//views/view[@id=$target]/popup/@id" />
                        </xsl:variable>
                        <xsl:value-of select="concat($indentation1,'uib_popup_context* pc = uib_create_popup(&quot;',$popupId,'&quot;);',$newline)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($indentation1,'Elm_Object_Item* navi_item = uib_util_push_view(',$targetString,');',$newline)" />
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="concat($indentation1,.,'_post(', $firstParam, ', ','vc, ','obj, ','event_info);',$newline,'}',$newline)" />
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template match="view">
		<xsl:param name="view" />
		<xsl:param name="level" select="count(./ancestor::*)" />
		<xsl:param name="parent" />
		<xsl:call-template name="view.comment" />
		<xsl:call-template name="view.connection.include" />
		<xsl:call-template name="view.connection.definition" />
	</xsl:template>
</xsl:stylesheet>
