<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="databinding_children_count" select="count(//dataBinding//*)" />
		<xsl:if test="$databinding_children_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
 * This file was generated by UI Builder.
 * This file will be auto-generated each and everytime you save your project.
 * Do not hand edit this file.
 ********************************************************************************/

#include "uib_databinding_common.h"
#include <contacts_service.h>
#include <contacts_errors.h>
#include <libxml2/libxml/parser.h>
#include <libxml2/libxml/xpath.h>

static void db_json_content_handler(Evas_Object*, char*, widget_binding_type,
		JsonNode *, Databinding_callback, SetWidgetElementValue_callback,
		Databinding_callback, UIB_DATASOURCE_CONTENT_TYPE);

static void db_xml_content_handler(Evas_Object*, char*, widget_binding_type,
		xmlDocPtr, Databinding_callback, SetWidgetElementValue_callback,
		Databinding_callback, UIB_DATASOURCE_CONTENT_TYPE);

static bool processNode(xmlNodePtr, JsonReader*, JsonNodeType);

char* get_json_data_from_builder(JsonBuilder* jsonBuilder) {
	//Verify generated Json
	JsonGenerator* jsonGenerator = json_generator_new();
	JsonNode* rootNode = json_builder_get_root(jsonBuilder);
	json_generator_set_root(jsonGenerator, rootNode);
	json_generator_set_pretty(jsonGenerator, false);
	char* json_string = json_generator_to_data(jsonGenerator, NULL);
	//json_to_string(json_builder_get_root(jsonBuilder),true);
	dlog_print(DLOG_INFO, LOG_TAG, "print generated json %s", json_string);
	g_object_unref(rootNode);
	g_object_unref(jsonGenerator);
	return json_string;
}

char* get_json_data_from_node(JsonNode* rootNode) {
	//Verify generated Json
	char* json_string = NULL;
	if (rootNode != NULL) {
		JsonGenerator* jsonGenerator = json_generator_new();
		json_generator_set_root(jsonGenerator, rootNode);
		json_generator_set_pretty(jsonGenerator, false);
		json_string = json_generator_to_data(jsonGenerator, NULL);
		//json_to_string(json_builder_get_root(jsonBuilder),true);
		dlog_print(DLOG_INFO, LOG_TAG, "print generated json %s", json_string);
		g_object_unref(jsonGenerator);
	}
	return json_string;
}

char* get_xml_data_from_node(xmlDocPtr rootNode) {
	//Verify generated Json
	char* xml_string = NULL;
	int size;
	xmlDocDumpFormatMemory(rootNode, &xml_string, &size, 1);
	return xml_string;
}

char* trim_quotes(char* str) {
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s trim quotes for %s", __func__, str);
	if (str != NULL) {
		unsigned int len = strlen(str);
		if (len == 0) {
			return str;
		}
		int begin = 0, end = len - 1;
		if (str[0] == '"')
			begin = 1;
		if (str[end] == '"')
			end--;
		if ((begin != 0) || (end != len - 1)) {
			int length = end + 1;
			int j = 0;
			for (int i = begin; i < length; ++i) {
				str[j++] = str[i];
			}
			str[j] = '\0';
		}
	}
	dlog_print(DLOG_DEBUG, LOG_TAG,
			"%s trimmed string after removing quotes %s", __func__, str);
	return str;
}

/**
 * @brief Function connects to the contacts database.
 * @return This function returns 'true' if the function succeeds,
 * otherwise 'false' is returned.
 */
bool data_contacts_common_connect() {
	int ret = contacts_connect();
	if (ret != CONTACTS_ERROR_NONE)
		dlog_print(DLOG_ERROR, LOG_TAG, "contacts_connect() failed. Err= %d.",
				ret);

	return (ret == CONTACTS_ERROR_NONE);
}

/**
 * @brief Function disconnects from the contacts database.
 * @return This function returns 'true' if the function succeeds,
 * otherwise 'false' is returned.
 */
bool data_contacts_common_disconnect() {
	int ret = contacts_disconnect();
	if (ret != CONTACTS_ERROR_NONE)
		dlog_print(DLOG_ERROR, LOG_TAG,
				"contacts_disconnect() failed. Err= %d.", ret);

	return (ret == CONTACTS_ERROR_NONE);
}

void bind_data(Evas_Object* widget, char* binding_element_path,
		widget_binding_type binding_type, void** root_element,
		Databinding_callback pre_db_cb,
		SetWidgetElementValue_callback databind_cb,
		Databinding_callback post_db_cb,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type) {
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s - ", __func__);
	if (root_element == NULL)
		return;

	xmlDocPtr docPtr = (xmlDocPtr) root_element[0];
	db_xml_content_handler(widget, binding_element_path, binding_type, docPtr,
			pre_db_cb, databind_cb, post_db_cb, ds_content_type);
}

static void db_json_content_handler(Evas_Object* widget,
		char* binding_element_path, widget_binding_type binding_type,
		JsonNode * rootNode, Databinding_callback pre_db_cb,
		SetWidgetElementValue_callback databind_cb,
		Databinding_callback post_db_cb,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type) {

	JsonParser *parser = json_parser_new();
	char* json_data = get_json_data_from_node(rootNode);
	if (json_parser_load_from_data(parser, json_data, strlen(json_data),
	NULL)) {

		JsonNode *result;
		JsonPath *path = json_path_new();
		json_path_compile(path, binding_element_path, NULL);
		result = json_path_match(path, json_parser_get_root(parser));

		//TODO: Remove from generated code
		//get_json_data_from_node(result);
		if (pre_db_cb != NULL) {
			pre_db_cb(widget, binding_element_path, binding_type, &rootNode,
					ds_content_type);
		}
		JsonArray* resultArray = json_node_get_array(result);
		if (databind_cb != NULL) {
			if (binding_type == foreach) {
				for (int i = 0; i < json_array_get_length(resultArray); ++i) {
					JsonNode* element = json_array_get_element(resultArray, i);
					char* element_data = trim_quotes(
							get_json_data_from_node(element));
					databind_cb(widget, binding_type, element_data);
					g_free(element_data);
				}
			} else if (binding_type == text) {
				JsonNode* element = json_array_get_element(resultArray, 0);
				char* element_data = trim_quotes(
						get_json_data_from_node(element));
				databind_cb(widget, binding_type, element_data);
				g_free(element_data);
			}
		}
		g_object_unref(path);
		//Frees up memory allocated to element & resultArray as well
		json_node_free(result);
	}
	g_free(json_data);
	g_object_unref(parser);
	if (post_db_cb != NULL) {
		post_db_cb(widget, binding_element_path, binding_type, &rootNode,
				ds_content_type);
	}
}

static void db_xml_content_handler(Evas_Object* widget,
		char* binding_element_path, widget_binding_type binding_type,
		xmlDocPtr docPtr, Databinding_callback pre_db_cb,
		SetWidgetElementValue_callback databind_cb,
		Databinding_callback post_db_cb,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type) {
	xmlXPathContextPtr context;
	xmlXPathObjectPtr result;
	xmlNodeSetPtr nodeSet;
	char * xml_data = get_xml_data_from_node(docPtr);
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s - Received xml doc %s", __func__,
			xml_data);
	xmlFree(xml_data);

	context = xmlXPathNewContext(docPtr);
	if (context == NULL) {
		dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__,
				"Error found in xmlXPathNewContext");
	}
	result = xmlXPathEvalExpression((const xmlChar*) binding_element_path,
			context);
	xmlXPathFreeContext(context);
	if (result == NULL) {
		dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__,
				"Error found in xmlXPathEvalExpression");
		return;
	}
	if (xmlXPathNodeSetIsEmpty(result->nodesetval)) {
		xmlXPathFreeObject(result);
		dlog_print(DLOG_DEBUG, LOG_TAG, "%s - %s", __func__,
				"No result found after xpath evaluation");
		return;
	}
	if (pre_db_cb != NULL) {
		pre_db_cb(widget, binding_element_path, binding_type, &docPtr,
				ds_content_type);
	}

	nodeSet = result->nodesetval;
	if (binding_type == foreach) {
		for (int i = 0; i < nodeSet->nodeNr; i++) {
			char* element_data = trim_quotes(
					xmlNodeListGetString(docPtr,
							nodeSet->nodeTab[i]->xmlChildrenNode, 1));
			databind_cb(widget, binding_type, element_data);
			xmlFree(element_data);
		}
	} else if (binding_type == text) {
		char* element_data = trim_quotes(
				xmlNodeListGetString(docPtr,
					nodeSet->nodeTab[0]->xmlChildrenNode, 1));
		databind_cb(widget, binding_type, element_data);
		xmlFree(element_data);
	}
	xmlXPathFreeObject(result);

	if (post_db_cb != NULL) {
		post_db_cb(widget, binding_element_path, binding_type, &docPtr,
				ds_content_type);
	}
}

xmlDocPtr convert_json_to_xml(JsonNode* root_node) {
	//Begin xml document
	xmlDocPtr datasource_xmlDoc = xmlNewDoc(BAD_CAST "1.0");

	JsonReader* reader = json_reader_new(root_node);

	xmlNodePtr xml_root_node = xmlNewNode(NULL, BAD_CAST "root");
	xmlDocSetRootElement(datasource_xmlDoc, xml_root_node);

	processNode(xml_root_node, reader, JSON_NODE_OBJECT);

	g_object_unref(reader);

	return datasource_xmlDoc;
}

static bool processNode(xmlNodePtr parentXMLNodePtr, JsonReader* reader, JsonNodeType parentNodeType) {

	if (json_reader_is_array(reader)) {
		const gchar* mem_name = json_reader_get_member_name(reader);
		gchar* member_name = (gchar*) malloc(sizeof(gchar*) * strlen(mem_name));
		strcpy(member_name, mem_name);
		int nElements = json_reader_count_elements(reader);
		for (int i = 0; i < nElements; ++i) {

			if (!json_reader_read_element(reader, i)) {
				const GError * error = json_reader_get_error(reader);
				dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__,
						error->message);
				return FALSE;
			}

			if (json_reader_is_object(reader)) {
				xmlNodePtr obj_arr_xml_node_ptr = xmlNewChild(parentXMLNodePtr, NULL,
						(const xmlChar*) member_name, NULL);
				if (!processNode(obj_arr_xml_node_ptr, reader, JSON_NODE_ARRAY)) {
					return FALSE;
				}
			} else {
				JsonNode* node = json_reader_get_value(reader);
				if (node == NULL) {
					const GError * error = json_reader_get_error(reader);
					if (error != NULL) {
						dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__,
								error->message);
					}
					return FALSE;
				}
				char * element_data = trim_quotes(get_json_data_from_node(node));
				xmlNewTextChild(parentXMLNodePtr, NULL, (const xmlChar*) member_name,
						(const xmlChar*) element_data);
			}
			json_reader_end_element(reader);
		}
		free(member_name);

	} else if (json_reader_is_object(reader)) {
		const gchar* member_name = json_reader_get_member_name(reader);
		xmlNodePtr obj_node_ptr = NULL;
		if ((member_name == NULL) || (parentNodeType == JSON_NODE_ARRAY)) {
			//It's the root object, therefore using passed root node as parent
			obj_node_ptr = parentXMLNodePtr;
		} else {
			obj_node_ptr = xmlNewChild(parentXMLNodePtr, NULL,
					(const xmlChar*) member_name, NULL);
		}
		int nMembers = json_reader_count_members(reader);
		gchar ** member_list = json_reader_list_members(reader);
		for (int i = 0; i < nMembers; ++i) {
			if (!json_reader_read_member(reader, member_list[i])) {
				const GError * error = json_reader_get_error(reader);
				dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__,
						error->message);
				return FALSE;
			}
			if (!processNode(obj_node_ptr, reader, JSON_NODE_OBJECT)) {
				return FALSE;
			}
			json_reader_end_member(reader);
		}

	} else if (json_reader_is_value(reader)) {
		const gchar* member_name = json_reader_get_member_name(reader);
		JsonNode* node = json_reader_get_value(reader);
		if (node == NULL) {
			const GError * error = json_reader_get_error(reader);
			if (error != NULL) {
				dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__,
						error->message);
			}
			return FALSE;
		}
		char * element_data = trim_quotes(get_json_data_from_node(node));
		xmlNewTextChild(parentXMLNodePtr, NULL, (const xmlChar*) member_name,
				(const xmlChar*) element_data);
	} else {
		//ERROR state
		const GError * error = json_reader_get_error(reader);
		dlog_print(DLOG_ERROR, LOG_TAG, "%s - %s", __func__, error->message);
		return FALSE;
	}
	return TRUE;
}
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
