<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="data_bind_count" select="count(//flipselectoritem[@data_bind != ''])" />
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'"></xsl:value-of>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="views">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef MANAGED_INC_DATABINDING_UIB_WIDGET_HANDLER_FLIPSELECTORITEM_H_
#define MANAGED_INC_DATABINDING_UIB_WIDGET_HANDLER_FLIPSELECTORITEM_H_

#include "uib_databinding_common.h"

widget_handler_st* flipselectoritem_widget_handler_get_instance();

#endif
]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>