<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">

	<xsl:template match="genlistitem">
		<xsl:param name="parent" />
		<xsl:param name="listParent" />
		<xsl:param name="indentation" />
		<xsl:param name="is_version_rm_support" />
		<xsl:value-of
			select="concat($indentation, 'vc->', @id, '= create_circle_genlist_item(vc->', $parent, ', _UIB_LOCALE(&quot;', @text, '&quot;), _UIB_LOCALE(&quot;', @sub_text, '&quot;), &quot;', @image_path, '&quot;,', '&quot;', @standard_icon, '&quot;, &quot;', @end_image_path, '&quot;,', '&quot;', @end_standard_icon, '&quot;, ')" />
		<xsl:choose>
			<xsl:when test="string-length($listParent) = 0">
				<xsl:value-of select="concat('NULL', ', ')" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat('vc->', $listParent, ', ')" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="concat('&quot;', @item_style, '&quot;, ')" />
		<xsl:variable name="callback">
			<xsl:apply-templates select="event" mode="item_event">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="view" select="./ancestor::view/@id" />
				<!-- Storyboard_START -->
				<xsl:with-param name="target" select="event/@target" />
				<!-- Storyboard_END -->
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($callback) != 0">
				<xsl:value-of select="concat('(Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat( 'NULL, NULL);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="$parent" />
			<xsl:with-param name="listParent" select="@id" />
			<xsl:with-param name="indentation" select="$indentation" />
		</xsl:apply-templates>
		<xsl:if test="string-length(@selected) != 0">
			<xsl:choose>
				<xsl:when test="@selected = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_genlist_item_selected_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_genlist_item_selected_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
