/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.project.core;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.efluibuilder.codegenerator.CodeGenerator;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorException;

public final class NUIBBuilder
extends IncrementalProjectBuilder {
    private static final String ID = "org.tizen.efluibuilder.builder";
    private static Logger logger = LoggerFactory.getLogger(NUIBBuilder.class);

    public static String getId() {
        return ID;
    }

    protected IProject[] build(int n, Map<String, String> map, IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        switch (n) {
            case 10: {
                Path path = new Path("layout/layout.xml");
                Path path2 = new Path("res/theme/custom_theme.edj");
                Path path3 = new Path("src/managed/");
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                IResourceDelta iResourceDelta = this.getDelta(iProject);
                if (iResourceDelta != null) {
                    iResourceDelta.accept(new IResourceDeltaVisitor((IPath)path, atomicBoolean, (IPath)path3, (IPath)path2){
                        private final /* synthetic */ IPath val$xmlPath;
                        private final /* synthetic */ AtomicBoolean val$bNeedGeneration;
                        private final /* synthetic */ IPath val$managedPath;
                        private final /* synthetic */ IPath val$customThemePath;
                        {
                            this.val$xmlPath = iPath;
                            this.val$bNeedGeneration = atomicBoolean;
                            this.val$managedPath = iPath2;
                            this.val$customThemePath = iPath3;
                        }

                        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                            IPath iPath = iResourceDelta.getProjectRelativePath();
                            if (this.val$xmlPath.equals((Object)iPath)) {
                                this.val$bNeedGeneration.set(true);
                            }
                            if (this.val$managedPath.isPrefixOf(iPath)) {
                                this.val$bNeedGeneration.set(true);
                            }
                            if (this.val$customThemePath.equals((Object)iPath)) {
                                this.val$bNeedGeneration.set(true);
                            }
                            return !this.val$bNeedGeneration.get();
                        }
                    });
                }
                if (!atomicBoolean.get()) break;
            }
            case 6: {
                logger.trace("Generate C/C++ codes from layout.xml.");
                this.build(iProject);
                break;
            }
            case 9: {
                logger.info("AUTO_BUILD");
                break;
            }
            case 15: {
                logger.info("CLEAN_BUILD");
                break;
            }
        }
        return null;
    }

    private void build(IProject iProject) throws CoreException {
        CodeGenerator codeGenerator = new CodeGenerator(iProject);
        try {
            codeGenerator.generate();
        }
        catch (CodeGeneratorException codeGeneratorException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.getProject();
        CodeGenerator codeGenerator = new CodeGenerator(iProject);
        try {
            codeGenerator.clean();
        }
        catch (CodeGeneratorException codeGeneratorException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }
}

