/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.project.core;

import java.util.Arrays;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.efluibuilder.project.core.Messages;
import org.tizen.efluibuilder.project.core.NUIBBuilder;
import org.tizen.efluibuilder.project.core.NUIBNature;
import org.tizen.efluibuilder.utility.IDEUtil;

public class NUIBProjectUtil {
    private static final String FILE_LAYOUT_META = "layout/layout.xml";

    public static void addNature(IProject iProject, IProgressMonitor iProgressMonitor) throws ProcessFailureException {
        String[] stringArray;
        String[] stringArray2;
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            throw new ProcessFailureException(coreException.getMessage());
        }
        String[] stringArray3 = stringArray2 = iProjectDescription.getNatureIds();
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray = stringArray3[n2];
            if (stringArray.equals(NUIBNature.getId())) {
                return;
            }
            ++n2;
        }
        stringArray = Arrays.copyOf(stringArray2, stringArray2.length + 1);
        stringArray[stringArray2.length] = NUIBNature.getId();
        iProjectDescription.setNatureIds(stringArray);
        try {
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new ProcessFailureException(coreException.getMessage());
        }
    }

    public static boolean existNature(IProject iProject) throws ProcessFailureException {
        String[] stringArray;
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            throw new ProcessFailureException(coreException.getMessage());
        }
        String[] stringArray2 = stringArray = iProjectDescription.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.equals(NUIBNature.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void open(IProject iProject) throws ProcessFailureException {
        IFile iFile = iProject.getFile(FILE_LAYOUT_META);
        if (!iFile.exists()) {
            throw new ProcessFailureException(Messages.MESSAGE_DIALOG_LAYOUT_FILE_NOT_FOUND);
        }
        IDEUtil.open((IFile)iFile);
    }

    public static void setBuildSpec(IProject iProject) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(NUIBBuilder.getId())) {
                return;
            }
            ++n;
        }
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
        System.arraycopy(iCommandArray, 0, iCommandArray2, 1, iCommandArray.length);
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName(NUIBBuilder.getId());
        iCommandArray2[0] = iCommand;
        iProjectDescription.setBuildSpec(iCommandArray2);
        iProject.setDescription(iProjectDescription, null);
    }
}

