/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.tizen.common.ui.font.TizenFonts;

public final class UIUtil {
    public static final int INPUT_TEXT_HEIGHT_SIZE = 37;
    public static final int BUTTON_SIZE = 100;
    public static final int HORIZONTAL_SPACING = 9;
    private static final String NAME_PATTERN = "^[a-zA-Z_]+[a-zA-Z0-9_]*$";
    private static ToolTip tooltip = null;

    public static GridData createGridData(int n, int n2, int n3, int n4) {
        GridData gridData = new GridData(n);
        if (n2 > 0) {
            gridData.horizontalSpan = n2;
        }
        if (n3 > 0) {
            gridData.horizontalAlignment = n3;
        }
        if (n4 > 0) {
            gridData.widthHint = n4;
        }
        return gridData;
    }

    public static boolean validateRegExp(String string) {
        return string != null && string.matches(NAME_PATTERN);
    }

    public static void showTooltipText(Text text, String string) {
        if (tooltip == null || tooltip.isDisposed()) {
            tooltip = new ToolTip(text.getShell(), 4104);
        }
        tooltip.setMessage(string);
        Point point = text.toDisplay(text.getSize().x, text.getSize().y);
        tooltip.setLocation(point.x - text.getSize().x + text.getBorderWidth(), point.y - text.getBorderWidth());
        tooltip.setAutoHide(true);
        tooltip.setVisible(true);
    }

    public static void hideTooltipText() {
        if (tooltip != null && !tooltip.isDisposed()) {
            tooltip.setVisible(false);
            tooltip.dispose();
            tooltip = null;
        }
    }

    public static FormData createFormData(FormAttachment formAttachment, FormAttachment formAttachment2, FormAttachment formAttachment3) {
        FormData formData = new FormData();
        formData.left = formAttachment;
        formData.right = formAttachment2;
        formData.top = formAttachment3;
        return formData;
    }

    public static Button createButtonWithGridLayout(Composite composite, String string, GridData gridData, int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            ++((GridLayout)composite.getLayout()).numColumns;
        }
        Button button = new Button(composite, n);
        if (bl3) {
            button.setFont(TizenFonts.getBoldFont());
        }
        button.setText(string);
        button.setLayoutData((Object)gridData);
        button.setEnabled(bl);
        return button;
    }

    public static void showMessagePopup(Shell shell, int n, String string, String string2) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, n);
            messageBox.setText(string);
            messageBox.setMessage(string2);
            messageBox.open();
        }
    }
}

