<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Ignore empty datamodels or datamodels tied to empty datasource -->
		<xsl:variable name="datamodel_count"
			select="count(//dataBinding//dataModel[@dataSource !=''][@modelType != 'Empty'])" />
		<xsl:if test="$datamodel_count>0">
			<xsl:call-template name="uib_common_datamodels_source" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="uib_common_datamodels_source">

		<!-- BEGIN : OUTPUT -->
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#include "uib_datamodels.h"
]]></xsl:text>
		<!-- Include other datamodels header #include "uib_dm0_datamodel.h" -->
		<xsl:for-each
			select="//dataBinding/dataModel[@dataSource !=''][@modelType != 'Empty']">
			<xsl:variable name="datamodel_id" select="@modelName" />
			<xsl:value-of
				select="concat('#include &quot;uib_',$datamodel_id,'_datamodel.h&quot;',$newline)" />
		</xsl:for-each>

		<xsl:text>
<![CDATA[static uib_datamodels_st g_uib_datamodels;

uib_datamodel_context* get_datamodel_context(const char* dataModelName) {
	uib_datamodel_context* datamodel_context = NULL;
]]>
</xsl:text>

		<xsl:for-each
			select="//dataBinding/dataModel[@dataSource !=''][@modelType != 'Empty']">
			<xsl:variable name="datamodel_id" select="@modelName" />
			<xsl:value-of
				select="concat($tab,'if(!strcmp(dataModelName, &quot;',$datamodel_id,'&quot;)){',$newline,
				$tab,$tab,'datamodel_context=get_',$datamodel_id,'_datamodel_context();',$newline,$tab,'}else')" />
		</xsl:for-each>
		<xsl:value-of select="concat('{',$newline,$tab,'}',$newline )" />

		<xsl:value-of select="concat($newline,$tab,'return datamodel_context;' )" />
		<xsl:value-of select="concat($newline,'}',$newline)" />

		<xsl:value-of select="concat('void cleanup_datamodels() {',$newline )" />
		<xsl:for-each
			select="//dataBinding/dataModel[@dataSource !=''][@modelType != 'Empty']">
			<xsl:variable name="datamodel_id" select="@modelName" />
			<xsl:value-of
				select="concat($tab,'cleanup_',$datamodel_id,'_datamodel();',$newline)" />
		</xsl:for-each>
		<xsl:value-of select="concat('}', $newline)" />

		<!-- void register_attached_datasource_update_cb(const char* dataModelName, 
			void (*func_ptr)()) -->
		<xsl:value-of
			select="concat($newline,'void register_attached_datasource_update_cb(void (*callback)()) {',$newline,
	 $tab,'uib_datasource_manager_get_instance()->register_datasource_update_cb(callback);',$newline)" />
		<xsl:value-of select="concat('}',$newline )" />
		<xsl:text>
<![CDATA[uib_datamodels_st* uib_datamodels_get_instance() {
	if (!g_uib_datamodels._is_init) {
		g_uib_datamodels._is_init = true;
		g_uib_datamodels.free_all_datamodels = &cleanup_datamodels;
		g_uib_datamodels.get_datamodel_context = &get_datamodel_context;
		g_uib_datamodels.register_attached_datasource_update_cb =
			&register_attached_datasource_update_cb;
	}
	return &g_uib_datamodels;
}
]]>		
		</xsl:text>
	</xsl:template>
</xsl:stylesheet>
