/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.converter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.tizen.efluibuilder.converter.ProjectConverter;
import org.tizen.efluibuilder.converter.ProjectConverterException;
import org.tizen.efluibuilder.utility.IDEUtil;

public final class ProjectConverterEditor
extends EditorPart {
    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (!(iEditorInput instanceof FileEditorInput)) {
            throw new IllegalArgumentException();
        }
        IFile iFile = ((FileEditorInput)iEditorInput).getFile();
        IProject iProject = iFile.getProject();
        boolean bl = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Native UI Builder Layout Converter", (String)"Would you like to convert meta file?");
        if (bl) {
            ProjectConverter projectConverter;
            try {
                projectConverter = new ProjectConverter(iProject);
                projectConverter.convert();
            }
            catch (ProjectConverterException projectConverterException) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)projectConverterException.getMessage());
                this.closeEditor();
                return;
            }
            projectConverter = iProject.getFile("layout/layout.xml");
            IDEUtil.open((IFile)projectConverter);
        }
        this.closeEditor();
    }

    public void createPartControl(Composite composite) {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
    }

    private void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectConverterEditor.this.getSite().getPage().closeEditor((IEditorPart)ProjectConverterEditor.this, false);
            }
        });
    }
}

