/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.efluibuilder.internal.connector.ConnectorEvent;
import org.tizen.efluibuilder.internal.connector.ConnectorFactory;
import org.tizen.efluibuilder.internal.connector.IConnectorListener;
import org.tizen.efluibuilder.internal.connector.IMessage;
import org.tizen.efluibuilder.internal.connector.IService;
import org.tizen.efluibuilder.internal.connector.MessageReader;
import org.tizen.efluibuilder.internal.connector.MessageWriter;
import org.tizen.efluibuilder.internal.renderer.util.DebugUtil;

public final class Connector
extends EventManager {
    private static Logger logger = LoggerFactory.getLogger(Connector.class);
    private static final int TIME_OUT = 1000;
    private String id = null;
    private Socket socket = null;
    private MessageReader reader = null;
    private MessageWriter writer = null;
    private Thread receiver = null;
    private Thread worker = null;
    private List<IMessage> messages = Collections.synchronizedList(new LinkedList());

    void setId(String string) {
        this.id = string;
    }

    String getId() {
        return this.id;
    }

    void create(IService iService) throws IOException {
        String string = iService.getIp();
        int n = iService.getPort();
        this.socket = new Socket(Proxy.NO_PROXY);
        try {
            this.socket.connect(new InetSocketAddress(string, n), 1000);
            this.socket.setKeepAlive(true);
            this.socket.setSoLinger(true, 0);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            logger.error(String.format("IP : %s | Port : %d", string, n));
            throw iOException;
        }
        try {
            InputStream inputStream = this.socket.getInputStream();
            OutputStream outputStream = this.socket.getOutputStream();
            this.reader = new MessageReader(inputStream);
            this.writer = new MessageWriter(outputStream);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            throw iOException;
        }
        this.receiver = new Receiver();
        this.receiver.setName(String.valueOf(iService.getId()) + " Receiver");
        this.receiver.start();
        this.worker = new Worker();
        this.worker.setName(String.valueOf(iService.getId()) + " Worker");
        this.worker.start();
    }

    void destroy() {
        try {
            if (this.socket != null && !this.socket.isInputShutdown()) {
                this.socket.shutdownInput();
            }
            if (this.socket != null && !this.socket.isOutputShutdown()) {
                this.socket.shutdownOutput();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
        }
        this.socket = null;
    }

    public void send(IMessage iMessage) {
        if (!this.isConnected()) {
            logger.error("Renderer connection not found");
        } else {
            try {
                this.writer.write(iMessage);
            }
            catch (IOException iOException) {
                logger.error(iOException.getMessage());
            }
        }
    }

    public void addConnectorListener(IConnectorListener iConnectorListener) {
        this.addListenerObject(iConnectorListener);
    }

    public void removeConnectorListener(IConnectorListener iConnectorListener) {
        this.removeListenerObject(iConnectorListener);
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    private void fireEvent(ConnectorEvent connectorEvent) {
        Object[] objectArray;
        if (connectorEvent == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (!this.isListenerAttached()) {
            return;
        }
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((IConnectorListener)object).receiveEvent(connectorEvent);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive() {
        IMessage iMessage = null;
        try {
            iMessage = this.reader.read();
            Assert.notNull((Object)iMessage);
        }
        catch (IOException iOException) {
            DebugUtil.debug(logger, ((Object)((Object)this)).getClass().getName(), iOException);
            ConnectorFactory.getDefault().destroyForcely(this.id);
            return;
        }
        if (iMessage.getType() == 11 && this.messages.size() > 0) {
            List<IMessage> list = this.messages;
            synchronized (list) {
                int n = 0;
                while (n < this.messages.size()) {
                    IMessage iMessage2 = this.messages.get(n);
                    if (iMessage.getId() == iMessage2.getId() && iMessage2.getType() == 11) {
                        this.messages.set(n, iMessage);
                        return;
                    }
                    ++n;
                }
            }
        }
        this.messages.add(iMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        if (this.messages.isEmpty()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                logger.error(interruptedException.getMessage());
            }
            return;
        }
        ArrayList<ConnectorEvent> arrayList = new ArrayList<ConnectorEvent>();
        List<IMessage> list = this.messages;
        synchronized (list) {
            int n = 0;
            while (n < this.messages.size()) {
                arrayList.add(new ConnectorEvent(this.messages.get(n).getId(), this.messages.get(n).getType(), this.messages.get(n)));
                ++n;
            }
            this.messages.clear();
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.fireEvent((ConnectorEvent)arrayList.get(n));
            ++n;
        }
    }

    private final class Receiver
    extends Thread {
        private Receiver() {
        }

        @Override
        public void run() {
            while (Connector.this.isConnected()) {
                Connector.this.receive();
            }
        }
    }

    private final class Worker
    extends Thread {
        private Worker() {
        }

        @Override
        public void run() {
            while (Connector.this.isConnected()) {
                Connector.this.work();
            }
        }
    }
}

