/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.renderer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.tizen.efluibuilder.internal.connector.Connector;
import org.tizen.efluibuilder.internal.connector.ConnectorFactory;
import org.tizen.efluibuilder.internal.renderer.Renderer;
import org.tizen.efluibuilder.renderer.IRenderer;

public final class RendererFactory {
    private static RendererFactory instance = null;
    private Map<Integer, IRenderer> renderers = new HashMap<Integer, IRenderer>();

    public static synchronized RendererFactory getDefault() {
        if (instance == null) {
            instance = new RendererFactory();
        }
        return instance;
    }

    private RendererFactory() {
    }

    public IRenderer create(String string, String string2, String string3) {
        Renderer renderer = null;
        try {
            ConnectorFactory connectorFactory = ConnectorFactory.getDefault();
            Connector connector = connectorFactory.create(string, string2);
            if (connector != null) {
                renderer = new Renderer(connector);
                int n = this.createId();
                renderer.setId(n);
                renderer.setVersion(string);
                renderer.setProfile(string2);
                renderer.setProject(string3);
                this.renderers.put(n, renderer);
            }
        }
        catch (IOException iOException) {
            renderer = null;
        }
        return renderer;
    }

    public void destroy(IRenderer iRenderer) {
        int n = iRenderer.getId();
        this.renderers.remove(n);
        ConnectorFactory connectorFactory = ConnectorFactory.getDefault();
        String string = ((Renderer)iRenderer).getVersion();
        String string2 = ((Renderer)iRenderer).getProfile();
        connectorFactory.destroy(string, string2);
    }

    private int createId() {
        int n = 0;
        while (this.renderers.containsKey(n)) {
            ++n;
        }
        return n;
    }
}

