<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Apply following template only once if static type datasource is found -->
		<xsl:variable name="static_datasource_count"
			select="count(//dataBinding//dataSource[@modelType='static'])" />
		<xsl:if test="$static_datasource_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>

	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
 * This file was generated by UI Builder.
 * This file will be auto-generated each and everytime you save your project.
 * Do not hand edit this file.
 ********************************************************************************/

#include "uib_datasource_handler_static.h"
#include <json-glib/json-glib.h>

static xmlDocPtr* staticDatasourceRootNode = NULL;

static uib_datasource_interface g_uib_static_datasource;

static void cleanup_datasource() {

}

void** get_datasource_root_element() {

	staticDatasourceRootNode = (xmlDocPtr*)malloc(sizeof(xmlDocPtr));

	return staticDatasourceRootNode;
}

static void register_datasource_update_callback(void (*func_ptr)()) {
	//Empty as static source is immutable
}

uib_datasource_interface* uib_static_datasource_get_instance() {
	if (!g_uib_static_datasource._is_init) {
		g_uib_static_datasource._is_init = true;
		g_uib_static_datasource.ds_type = static_source;
		g_uib_static_datasource.get_datasource_root_element =
				&get_datasource_root_element;
		g_uib_static_datasource.register_datasource_update_callback =
				&register_datasource_update_callback;
		g_uib_static_datasource.cleanup_datasource = &cleanup_datasource;
	}
	return &g_uib_static_datasource;
}
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
