<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="data_bind_count" select="count(//check[@data_bind != ''])" />
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'"></xsl:value-of>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="views">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
 * This file was generated by UI Builder.
 * This file will be auto-generated each and everytime you save your project.
 * Do not hand edit this file.
 ********************************************************************************/

#include <uib_widget_handler_checkbox.h>
#include <elm_object.h>

static widget_handler_st checkbox_widget_handler;

static void pre_binding_cb(Evas_Object* widget, char* binding_element_path,
		widget_binding_type binding_type, void** root_element,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type) {
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s - ", __func__);
	if (binding_type == text) {
		//Do nothing
	}
}

static void bind_data_callback(Evas_Object* widget,
		widget_binding_type binding_type, char* value_data) {
	if (binding_type == text) {
		elm_object_text_set(widget, _UIB_LOCALE(value_data));
	}
}

static void post_binding_cb(Evas_Object* widget, char* binding_element_path,
		widget_binding_type binding_type, void** root_element,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type) {
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s - ", __func__);
	if (binding_type == text) {
		// Show the label
		evas_object_show(widget);
	}
}

static void binding_cb(Evas_Object* widget, char* binding_element_path,
		widget_binding_type binding_type, void** root_element,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type) {
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s - ", __func__);
	if (root_element == NULL) {
		return;
	}
	bind_data(widget, binding_element_path, binding_type, root_element,
			pre_binding_cb, bind_data_callback, post_binding_cb,
			ds_content_type);
}

widget_handler_st* checkbox_widget_handler_get_instance() {
	if (checkbox_widget_handler.is_init == false) {
		checkbox_widget_handler.is_init = true;
		checkbox_widget_handler.binding_cb = &binding_cb;
	}
	return &checkbox_widget_handler;
}
]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>

